/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedTracerTest
extends ManagementTestSupport {
    @Test
    public void testDefaultTracer() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=" + this.context.getManagementName() + ",type=tracer,name=DefaultTracer");
        Assertions.assertNotNull((Object)on);
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on));
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)enabled, (String)"Should be enabled");
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:bar").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Long count = (Long)mbeanServer.getAttribute(on, "TraceCounter");
        Assertions.assertEquals((int)4, (int)count.intValue());
    }

    @Test
    public void testDefaultTracerPattern() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=" + this.context.getManagementName() + ",type=tracer,name=DefaultTracer");
        Assertions.assertNotNull((Object)on);
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on));
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)enabled, (String)"Should be enabled");
        mbeanServer.setAttribute(on, new Attribute("TracePattern", "foo*"));
        mbeanServer.invoke(on, "resetTraceCounter", null, null);
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:bar").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Long count = (Long)mbeanServer.getAttribute(on, "TraceCounter");
        Assertions.assertEquals((int)2, (int)count.intValue());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ManagedTracerTest.this.context.setUseBreadcrumb(Boolean.valueOf(false));
                ManagedTracerTest.this.context.setTracing(Boolean.valueOf(true));
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:foo")).id("foo")).to("mock:bar")).id("bar");
            }
        };
    }
}

