/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedTimerTest
extends ManagementTestSupport {
    @Test
    public void testTimer() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = this.getCamelObjectName("endpoints", "timer://foo\\?delay=5000&period=8000");
        Assertions.assertEquals((Object)true, (Object)mbeanServer.isRegistered(name), (String)"Should be registered");
        Long period = (Long)mbeanServer.getAttribute(name, "Period");
        Assertions.assertEquals((long)8000L, (long)period);
        String camelId = (String)mbeanServer.getAttribute(name, "CamelId");
        Assertions.assertEquals((Object)this.context.getManagementName(), (Object)camelId);
        mbeanServer.setAttribute(name, new Attribute("Period", 500));
        mbeanServer.setAttribute(name, new Attribute("Delay", 250));
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.reset();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=consumers,*"), null);
        Assertions.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        mbeanServer.invoke(on, "stop", null, null);
        mbeanServer.invoke(on, "start", null, null);
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state, (String)"Should be started");
        mock.expectedMinimumMessageCount(3);
        mock.setResultWaitTime(3900L);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("timer://foo?delay=5000&period=8000").to("mock:result");
            }
        };
    }
}

