/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedRegisterEndpointTest
extends ManagementTestSupport {
    @Test
    public void testLookupEndpointsByName() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = this.getCamelObjectName("endpoints", "direct://start");
        String uri = (String)mbeanServer.getAttribute(name, "EndpointUri");
        Assertions.assertEquals((Object)"direct://start", (Object)uri);
        name = this.getCamelObjectName("endpoints", "log://foo");
        uri = (String)mbeanServer.getAttribute(name, "EndpointUri");
        Assertions.assertEquals((Object)"log://foo", (Object)uri);
        name = this.getCamelObjectName("endpoints", "mock://result");
        uri = (String)mbeanServer.getAttribute(name, "EndpointUri");
        Assertions.assertEquals((Object)"mock://result", (Object)uri);
        String id = (String)mbeanServer.getAttribute(name, "CamelId");
        Assertions.assertEquals((Object)this.context.getManagementName(), (Object)id);
        String state = (String)mbeanServer.getAttribute(name, "State");
        Assertions.assertEquals((Object)"Started", (Object)state);
        Boolean singleton = (Boolean)mbeanServer.getAttribute(name, "Singleton");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)singleton);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

