/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedProducerTest
extends ManagementTestSupport {
    @Test
    public void testProducer() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=producers,*"), null);
        Assertions.assertEquals((int)2, (int)set.size());
        for (ObjectName on : set) {
            boolean registered = mbeanServer.isRegistered(on);
            Assertions.assertTrue((boolean)registered, (String)"Should be registered");
            String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
            Assertions.assertTrue((uri.equals("log://foo") || uri.equals("mock://result") ? 1 : 0) != 0, (String)uri);
            String state = (String)mbeanServer.getAttribute(on, "State");
            Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state, (String)"Should be started");
        }
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").routeId("foo").to("log:foo")).to("mock:result");
            }
        };
    }
}

