/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedCamelContextSuspendResumeTest
extends ManagementTestSupport {
    @Test
    public void testManagedCamelContext() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getContextObjectName();
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered");
        String name = (String)mbeanServer.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)this.context.getManagementName(), (Object)name);
        String uptime = (String)mbeanServer.getAttribute(on, "Uptime");
        Assertions.assertNotNull((Object)uptime);
        long uptimeMillis = (Long)mbeanServer.getAttribute(on, "UptimeMillis");
        Assertions.assertTrue((uptimeMillis > 0L ? 1 : 0) != 0);
        String status = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)"Started", (Object)status);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        Object reply = mbeanServer.invoke(on, "requestBody", new Object[]{"direct:foo", "Hello World"}, new String[]{"java.lang.String", "java.lang.Object"});
        Assertions.assertEquals((Object)"Bye World", (Object)reply);
        mbeanServer.invoke(on, "suspend", null, null);
        status = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)"Suspended", (Object)status);
        mbeanServer.invoke(on, "resume", null, null);
        status = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)"Started", (Object)status);
        reply = mbeanServer.invoke(on, "requestBody", new Object[]{"direct:foo", "Hello Camel"}, new String[]{"java.lang.String", "java.lang.Object"});
        Assertions.assertEquals((Object)"Bye World", (Object)reply);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:foo").delay(10L).transform((Expression)this.constant("Bye World"));
            }
        };
    }
}

