/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.camel.management.JmxInstrumentationUsingPropertiesTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.parallel.ResourceLock;

@ResourceLock(value="java.lang.System.properties")
@DisabledOnOs(value={OS.AIX})
public class JmxInstrumentationUsingPlatformMBSTest
extends JmxInstrumentationUsingPropertiesTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        System.setProperty("org.apache.camel.jmx.usePlatformMBeanServer", "false");
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        System.clearProperty("org.apache.camel.jmx.usePlatformMBeanServer");
    }

    @Override
    @Test
    public void testMBeanServerType() throws Exception {
        try {
            this.mbsc.getMBeanInfo(new ObjectName("java.lang:type=OperatingSystem"));
            Assertions.fail();
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    @Override
    protected MBeanServerConnection getMBeanConnection() throws Exception {
        if (this.mbsc == null) {
            ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
            for (MBeanServer server : servers) {
                if (!this.domainName.equals(server.getDefaultDomain())) continue;
                this.mbsc = server;
                break;
            }
        }
        return this.mbsc;
    }
}

