/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AvailablePortFinder {
    private static final Logger LOG = LoggerFactory.getLogger(AvailablePortFinder.class);

    private AvailablePortFinder() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getNextAvailable() {
        try (ServerSocket ss = new ServerSocket();){
            ss.setReuseAddress(true);
            ss.bind(new InetSocketAddress((InetAddress)null, 0), 1);
            int port = ss.getLocalPort();
            LOG.info("getNextAvailable() -> {}", (Object)port);
            int n = port;
            return n;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot find free port", e);
        }
    }
}

