/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.CamelContext;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedSendDynamicProcessorTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementStrategy().getManagementAgent().setStatisticsLevel(ManagementStatisticsLevel.Extended);
        return context;
    }

    @Test
    public void testManageSendDynamicProcessor() throws Exception {
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(2);
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "whereto", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "whereto", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hi World", "whereto", (Object)"bar");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("processors", "mysend");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        Assertions.assertTrue((boolean)routeId.matches("route[0-9]+"));
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)this.context.getManagementName(), (Object)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        String uri = (String)mbeanServer.getAttribute(on, "Uri");
        Assertions.assertEquals((Object)"direct:${header.whereto}", (Object)uri);
        Boolean optimised = (Boolean)mbeanServer.getAttribute(on, "Optimised");
        Assertions.assertFalse((boolean)optimised);
        String pattern = (String)mbeanServer.getAttribute(on, "MessageExchangePattern");
        Assertions.assertNull((Object)pattern);
        TabularData data = (TabularData)mbeanServer.invoke(on, "extendedInformation", null, null);
        Assertions.assertNotNull((Object)data);
        Assertions.assertEquals((int)2, (int)data.size());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").toD("direct:${header.whereto}")).id("mysend");
                this.from("direct:foo").to("mock:foo");
                this.from("direct:bar").to("mock:bar");
            }
        };
    }
}

