/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedScheduledPollConsumerTest
extends ManagementTestSupport {
    @Test
    public void testScheduledPollConsumer() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=consumers,*"), null);
        Assertions.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered");
        String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
        Assertions.assertEquals((Object)("file://" + this.testDirectory() + "?backoffErrorThreshold=3&backoffIdleThreshold=2&backoffMultiplier=4&delay=4000"), (Object)uri);
        Long delay = (Long)mbeanServer.getAttribute(on, "Delay");
        Assertions.assertEquals((long)4000L, (long)delay);
        Long initialDelay = (Long)mbeanServer.getAttribute(on, "InitialDelay");
        Assertions.assertEquals((long)1000L, (long)initialDelay);
        Boolean fixedDelay = (Boolean)mbeanServer.getAttribute(on, "UseFixedDelay");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)fixedDelay);
        Boolean schedulerStarted = (Boolean)mbeanServer.getAttribute(on, "SchedulerStarted");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)schedulerStarted);
        String timeUnit = (String)mbeanServer.getAttribute(on, "TimeUnit");
        Assertions.assertEquals((Object)TimeUnit.MILLISECONDS.toString(), (Object)timeUnit);
        Integer backoffMultiplier = (Integer)mbeanServer.getAttribute(on, "BackoffMultiplier");
        Assertions.assertEquals((long)4L, (long)backoffMultiplier.longValue());
        Integer backoffCounter = (Integer)mbeanServer.getAttribute(on, "BackoffCounter");
        Assertions.assertEquals((long)0L, (long)backoffCounter.longValue());
        Integer backoffIdleThreshold = (Integer)mbeanServer.getAttribute(on, "BackoffIdleThreshold");
        Assertions.assertEquals((long)2L, (long)backoffIdleThreshold.longValue());
        Integer backoffErrorThreshold = (Integer)mbeanServer.getAttribute(on, "BackoffErrorThreshold");
        Assertions.assertEquals((long)3L, (long)backoffErrorThreshold.longValue());
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        Assertions.assertEquals((Object)"route1", (Object)routeId);
        mbeanServer.invoke(on, "stop", null, null);
        schedulerStarted = (Boolean)mbeanServer.getAttribute(on, "SchedulerStarted");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)schedulerStarted);
        mbeanServer.setAttribute(on, new Attribute("Delay", 2000));
        mbeanServer.invoke(on, "start", null, null);
        delay = (Long)mbeanServer.getAttribute(on, "Delay");
        Assertions.assertEquals((long)2000L, (long)delay);
        mbeanServer.setAttribute(on, new Attribute("UseFixedDelay", Boolean.FALSE));
        fixedDelay = (Boolean)mbeanServer.getAttribute(on, "UseFixedDelay");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)fixedDelay);
        mbeanServer.setAttribute(on, new Attribute("TimeUnit", TimeUnit.SECONDS.name()));
        timeUnit = (String)mbeanServer.getAttribute(on, "TimeUnit");
        Assertions.assertEquals((Object)TimeUnit.SECONDS.toString(), (Object)timeUnit);
        mbeanServer.setAttribute(on, new Attribute("InitialDelay", Long.valueOf("2000")));
        initialDelay = (Long)mbeanServer.getAttribute(on, "InitialDelay");
        Assertions.assertEquals((long)2000L, (long)initialDelay);
        this.context.stop();
        Assertions.assertFalse((boolean)mbeanServer.isRegistered(on), (String)"Should no longer be registered");
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from(ManagedScheduledPollConsumerTest.this.fileUri("?delay=4000&backoffMultiplier=4&backoffIdleThreshold=2&backoffErrorThreshold=3")).to("mock:result");
            }
        };
    }
}

