/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedRestRegistryTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getRegistry().bind("dummy-test", (Object)new DummyRestConsumerFactory());
        return context;
    }

    @Test
    public void testRestRegistry() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("services", "*");
        Set<ObjectName> names = mbeanServer.queryNames(on, null);
        ObjectName name = null;
        for (ObjectName service : names) {
            if (!service.toString().contains("DefaultRestRegistry")) continue;
            name = service;
            break;
        }
        Assertions.assertNotNull(name, (String)"Cannot find DefaultRestRegistry");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(name));
        Assertions.assertEquals((Object)3, (Object)mbeanServer.getAttribute(name, "NumberOfRestServices"));
        TabularData data = (TabularData)mbeanServer.invoke(name, "listRestServices", null, null);
        Assertions.assertEquals((int)3, (int)data.size());
        String json = (String)mbeanServer.invoke(name, "apiDocAsJson", null, null);
        Assertions.assertNull((Object)json);
        for (Route route : this.context.getRoutes()) {
            this.context.getRouteController().stopRoute(route.getId());
            this.context.removeRoute(route.getId());
        }
        Assertions.assertEquals((Object)0, (Object)mbeanServer.getAttribute(name, "NumberOfRestServices"));
        data = (TabularData)mbeanServer.invoke(name, "listRestServices", null, null);
        Assertions.assertEquals((int)0, (int)data.size());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.restConfiguration().host("localhost");
                this.rest("/say/hello/{name}").get().to("direct:hello").description("Calling direct route");
                ((ProcessorDefinition)this.rest("/say/bye").description("the bye rest service").get().consumes("application/json").description("I am saying bye world").route().routeId("myRestRoute").transform().constant((Object)"Bye World")).endRest().post().to("mock:update");
                ((RouteDefinition)this.from("direct:hello").description("The hello route")).transform().simple("Hello ${header.name}");
            }
        };
    }
}

