/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Expression;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ResequenceDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedResequencerTest
extends ManagementTestSupport {
    @Test
    public void testManageResequencer() throws Exception {
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedBodiesReceived(new Object[]{"A", "B", "C"});
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "num", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "num", (Object)"3");
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "num", (Object)"1");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("processors", "mysend");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        Assertions.assertEquals((Object)"route1", (Object)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)this.context.getManagementName(), (Object)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        String uri = (String)mbeanServer.getAttribute(on, "Expression");
        Assertions.assertEquals((Object)"header(num)", (Object)uri);
        Integer size = (Integer)mbeanServer.getAttribute(on, "BatchSize");
        Assertions.assertEquals((int)3, (int)size);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ResequenceDefinition)this.from("direct:start").resequence((Expression)this.header("num")).size(3).id("mysend")).to("mock:foo");
            }
        };
    }
}

