/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Collections;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.api.management.mbean.ComponentVerifierExtension;
import org.apache.camel.component.direct.DirectComponent;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.support.DefaultComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedComponentTest
extends ManagementTestSupport {
    private static final String[] VERIFY_SIGNATURE = new String[]{"java.lang.String", "java.util.Map"};

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.init();
        context.addComponent("my-verifiable-component", (Component)new MyVerifiableComponent());
        context.addComponent("direct", (Component)new DirectComponent());
        return context;
    }

    @Test
    public void testVerifySupported() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("components", "my-verifiable-component");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on));
        Assertions.assertTrue((boolean)((Boolean)this.invoke(mbeanServer, on, "isVerifySupported")));
        on = this.getCamelObjectName("components", "direct");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on));
        Assertions.assertFalse((boolean)((Boolean)this.invoke(mbeanServer, on, "isVerifySupported")));
    }

    @Test
    public void testVerify() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("components", "my-verifiable-component");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on));
        Assertions.assertTrue((boolean)((Boolean)this.invoke(mbeanServer, on, "isVerifySupported")));
        ComponentVerifierExtension.Result res = (ComponentVerifierExtension.Result)this.invoke(mbeanServer, on, "verify", new Object[]{"connectivity", Collections.emptyMap()}, VERIFY_SIGNATURE);
        Assertions.assertEquals((Object)ComponentVerifierExtension.Result.Status.OK, (Object)res.getStatus());
        Assertions.assertEquals((Object)ComponentVerifierExtension.Scope.CONNECTIVITY, (Object)res.getScope());
        res = (ComponentVerifierExtension.Result)this.invoke(mbeanServer, on, "verify", new Object[]{"ConnEctivIty", Collections.emptyMap()}, VERIFY_SIGNATURE);
        Assertions.assertEquals((Object)ComponentVerifierExtension.Result.Status.OK, (Object)res.getStatus());
        Assertions.assertEquals((Object)ComponentVerifierExtension.Scope.CONNECTIVITY, (Object)res.getScope());
        res = (ComponentVerifierExtension.Result)this.invoke(mbeanServer, on, "verify", new Object[]{"PARAMETERS", Collections.emptyMap()}, VERIFY_SIGNATURE);
        Assertions.assertEquals((Object)ComponentVerifierExtension.Result.Status.OK, (Object)res.getStatus());
        Assertions.assertEquals((Object)ComponentVerifierExtension.Scope.PARAMETERS, (Object)res.getScope());
    }

    private static class MyVerifiableComponent
    extends DefaultComponent {
        public MyVerifiableComponent() {
            this.registerExtension(() -> new DefaultComponentVerifierExtension("my-verifiable-component", this.getCamelContext()){

                protected ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
                    return ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.CONNECTIVITY).build();
                }

                protected ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
                    return ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.PARAMETERS).build();
                }
            });
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
            throw new UnsupportedOperationException();
        }
    }
}

