/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.w3c.dom.Document;

public class ManagedCamelContextDumpRoutesCoverageAsXml
extends ManagementTestSupport {
    public void testRouteCoverageStats() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getContextObjectName();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(2);
        this.template.asyncSendBody("direct:start", (Object)"Hello World");
        this.template.asyncSendBody("direct:bar", (Object)"Hi World");
        this.template.asyncSendBody("direct:bar", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        String xml = (String)mbeanServer.invoke(on, "dumpRoutesCoverageAsXml", null, null);
        this.log.info(xml);
        Assertions.assertTrue((boolean)xml.contains("exchangesTotal=\"3\""));
        Assertions.assertTrue((boolean)xml.contains("exchangesTotal=\"2\""));
        Assertions.assertTrue((boolean)xml.contains("customId=\"true\""));
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)xml);
        Assertions.assertNotNull((Object)doc);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").routeId("foo").to("log:foo")).delay(100L).to("mock:foo");
                ((RouteDefinition)this.from("direct:bar").routeId("bar").to("log:bar")).to("mock:bar");
            }
        };
    }
}

