/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedProducerCacheMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.ProducerCache;

@ManagedResource(description="Managed ProducerCache")
public class ManagedProducerCache
extends ManagedService
implements ManagedProducerCacheMBean {
    private final ProducerCache producerCache;

    public ManagedProducerCache(CamelContext context, ProducerCache producerCache) {
        super(context, (Service)producerCache);
        this.producerCache = producerCache;
    }

    public ProducerCache getProducerCache() {
        return this.producerCache;
    }

    public String getSource() {
        if (this.producerCache.getSource() != null) {
            return this.producerCache.getSource().toString();
        }
        return null;
    }

    public Integer getSize() {
        return this.producerCache.size();
    }

    public Integer getMaximumCacheSize() {
        return this.producerCache.getCapacity();
    }

    public Long getHits() {
        return this.producerCache.getHits();
    }

    public Long getMisses() {
        return this.producerCache.getMisses();
    }

    public Long getEvicted() {
        return this.producerCache.getEvicted();
    }

    public void resetStatistics() {
        this.producerCache.resetCacheStatistics();
    }

    public void purge() {
        this.producerCache.purge();
    }

    public Boolean isEventNotifierEnabled() {
        return this.producerCache.isEventNotifierEnabled();
    }
}

