/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.lumberjack.io;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.camel.component.lumberjack.io.LumberjackAckEncoder;
import org.apache.camel.component.lumberjack.io.LumberjackFrameDecoder;
import org.apache.camel.component.lumberjack.io.LumberjackMessageHandler;
import org.apache.camel.component.lumberjack.io.LumberjackMessageProcessor;

final class LumberjackChannelInitializer
extends ChannelInitializer<Channel> {
    private final SSLContext sslContext;
    private final EventExecutorGroup messageExecutorService;
    private final LumberjackMessageProcessor messageProcessor;

    LumberjackChannelInitializer(SSLContext sslContext, EventExecutorGroup messageExecutorService, LumberjackMessageProcessor messageProcessor) {
        this.sslContext = sslContext;
        this.messageExecutorService = messageExecutorService;
        this.messageProcessor = messageProcessor;
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.sslContext != null) {
            SSLEngine sslEngine = this.sslContext.createSSLEngine();
            sslEngine.setUseClientMode(false);
            pipeline.addLast(new ChannelHandler[]{new SslHandler(sslEngine)});
        }
        pipeline.addLast(new ChannelHandler[]{new LumberjackAckEncoder()});
        pipeline.addLast(this.messageExecutorService, new ChannelHandler[]{new LumberjackFrameDecoder(), new LumberjackMessageHandler(this.messageProcessor)});
    }
}

