/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.service.lra;

import java.net.URL;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StaticService;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.saga.CamelSagaCoordinator;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.saga.CamelSagaStep;
import org.apache.camel.service.lra.LRAClient;
import org.apache.camel.service.lra.LRASagaCoordinator;
import org.apache.camel.service.lra.LRASagaRoutes;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.service.ServiceSupport;

@JdkService(value="lra-saga-service")
@Configurer
@ManagedResource(description="Managed LRASagaService")
public class LRASagaService
extends ServiceSupport
implements StaticService,
CamelSagaService {
    private CamelContext camelContext;
    private ScheduledExecutorService executorService;
    private LRAClient client;
    private LRASagaRoutes routes;
    private final Set<String> sagaURIs = ConcurrentHashMap.newKeySet();
    @Metadata
    private String coordinatorUrl;
    @Metadata
    private String coordinatorContextPath = "/lra-coordinator";
    @Metadata
    private String localParticipantUrl;
    @Metadata
    private String localParticipantContextPath = "/lra-participant";

    public CompletableFuture<CamelSagaCoordinator> newSaga() {
        return this.client.newLRA().thenApply(url -> new LRASagaCoordinator(this, (URL)url));
    }

    public CompletableFuture<CamelSagaCoordinator> getSaga(String id) {
        CompletableFuture<CamelSagaCoordinator> coordinator = new CompletableFuture<CamelSagaCoordinator>();
        try {
            coordinator.complete(new LRASagaCoordinator(this, new URL(id)));
        }
        catch (Exception ex) {
            coordinator.completeExceptionally(ex);
        }
        return coordinator;
    }

    public void registerStep(CamelSagaStep step) {
        step.getCompensation().map(Endpoint::getEndpointUri).map(this.sagaURIs::add);
        step.getCompletion().map(Endpoint::getEndpointUri).map(this.sagaURIs::add);
    }

    protected void doStart() throws Exception {
        if (this.executorService == null) {
            this.executorService = this.camelContext.getExecutorServiceManager().newDefaultScheduledThreadPool((Object)this, "saga-lra");
        }
        if (this.client == null) {
            this.client = new LRAClient(this);
        }
    }

    protected void doStop() throws Exception {
        if (this.executorService != null) {
            this.camelContext.getExecutorServiceManager().shutdownGraceful((ExecutorService)this.executorService);
            this.executorService = null;
        }
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        if (this.routes == null) {
            this.routes = new LRASagaRoutes(this);
            try {
                this.camelContext.addRoutes((RoutesBuilder)this.routes);
            }
            catch (Exception ex) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)ex);
            }
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    public LRAClient getClient() {
        return this.client;
    }

    @ManagedAttribute(description="Coordinator URL")
    public String getCoordinatorUrl() {
        return this.coordinatorUrl;
    }

    public void setCoordinatorUrl(String coordinatorUrl) {
        this.coordinatorUrl = coordinatorUrl;
    }

    @ManagedAttribute(description="Coordinator context-path")
    public String getCoordinatorContextPath() {
        return this.coordinatorContextPath;
    }

    public void setCoordinatorContextPath(String coordinatorContextPath) {
        this.coordinatorContextPath = coordinatorContextPath;
    }

    @ManagedAttribute(description="Local participant URL")
    public String getLocalParticipantUrl() {
        return this.localParticipantUrl;
    }

    public void setLocalParticipantUrl(String localParticipantUrl) {
        this.localParticipantUrl = localParticipantUrl;
    }

    @ManagedAttribute(description="Local participant context-path")
    public String getLocalParticipantContextPath() {
        return this.localParticipantContextPath;
    }

    public void setLocalParticipantContextPath(String localParticipantContextPath) {
        this.localParticipantContextPath = localParticipantContextPath;
    }

    public Set<String> getRegisteredURIs() {
        return this.sagaURIs;
    }

    public String toString() {
        return "lra-saga-service";
    }
}

