/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.service.lra;

import java.util.HashSet;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.service.lra.LRASagaService;

public class LRASagaRoutes
extends RouteBuilder {
    private LRASagaService sagaService;

    public LRASagaRoutes(LRASagaService sagaService) {
        this.sagaService = sagaService;
    }

    public void configure() throws Exception {
        ((ChoiceDefinition)((RouteDefinition)((RouteDefinition)this.rest(this.sagaService.getLocalParticipantContextPath()).put("/compensate").route().id("lra-compensation")).process(this::verifyRequest)).choice().when(this.header("Camel-Saga-Compensate").isNotNull()).toD("${header.Camel-Saga-Compensate}")).end();
        ((ChoiceDefinition)((RouteDefinition)((RouteDefinition)this.rest(this.sagaService.getLocalParticipantContextPath()).put("/complete").route().id("lra-completion")).process(this::verifyRequest)).choice().when(this.header("Camel-Saga-Complete").isNotNull()).toD("${header.Camel-Saga-Complete}")).end();
    }

    private void verifyRequest(Exchange exchange) {
        String completionURI;
        if (exchange.getIn().getHeader("Long-Running-Action") == null) {
            throw new IllegalArgumentException("Missing Long-Running-Action header in received request");
        }
        HashSet<String> usedURIs = new HashSet<String>();
        String compensationURI = (String)exchange.getIn().getHeader("Camel-Saga-Compensate", String.class);
        if (compensationURI != null) {
            usedURIs.add(compensationURI);
        }
        if ((completionURI = (String)exchange.getIn().getHeader("Camel-Saga-Complete", String.class)) != null) {
            usedURIs.add(completionURI);
        }
        for (String uri : usedURIs) {
            if (this.sagaService.getRegisteredURIs().contains(uri)) continue;
            throw new IllegalArgumentException("URI " + uri + " is not allowed");
        }
    }
}

