/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.leveldb;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBFactory;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LevelDBFile
implements Service {
    private static final Logger LOG = LoggerFactory.getLogger(LevelDBFile.class);
    private DB db;
    private File file;
    private int writeBufferSize = 0x400000;
    private int maxOpenFiles = 1000;
    private int blockRestartInterval = 16;
    private int blockSize = 4096;
    private String compressionType;
    private boolean verifyChecksums = true;
    private boolean paranoidChecks;
    private long cacheSize = 0x2000000L;
    private boolean sync;

    public DB getDb() {
        return this.db;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getFileName() throws IOException {
        return this.file.getCanonicalPath();
    }

    public void setFileName(String fileName) {
        this.file = new File(fileName);
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }

    public int getMaxOpenFiles() {
        return this.maxOpenFiles;
    }

    public void setMaxOpenFiles(int maxOpenFiles) {
        this.maxOpenFiles = maxOpenFiles;
    }

    public int getBlockRestartInterval() {
        return this.blockRestartInterval;
    }

    public void setBlockRestartInterval(int blockRestartInterval) {
        this.blockRestartInterval = blockRestartInterval;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public String getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(String compressionType) {
        this.compressionType = compressionType;
    }

    public boolean isVerifyChecksums() {
        return this.verifyChecksums;
    }

    public void setVerifyChecksums(boolean verifyChecksums) {
        this.verifyChecksums = verifyChecksums;
    }

    public boolean isParanoidChecks() {
        return this.paranoidChecks;
    }

    public void setParanoidChecks(boolean paranoidChecks) {
        this.paranoidChecks = paranoidChecks;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public WriteOptions getWriteOptions() {
        WriteOptions options = new WriteOptions();
        options.sync(this.sync);
        return options;
    }

    public void start() {
        if (this.getFile() == null) {
            throw new IllegalArgumentException("A file must be configured");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting LevelDB using file: {}", (Object)this.getFile());
        }
        Options options = new Options().writeBufferSize(this.writeBufferSize).maxOpenFiles(this.maxOpenFiles).blockRestartInterval(this.blockRestartInterval).blockSize(this.blockSize).verifyChecksums(this.verifyChecksums).paranoidChecks(this.paranoidChecks).cacheSize(this.cacheSize);
        if ("snappy".equals(this.compressionType)) {
            options.compressionType(CompressionType.SNAPPY);
        } else {
            options.compressionType(CompressionType.NONE);
        }
        options.createIfMissing(true);
        try {
            Path dbFile = Paths.get(this.getFileName(), new String[0]);
            Files.createDirectories(dbFile.getParent(), new FileAttribute[0]);
            DBFactory factory = this.getFactory();
            this.db = factory.open(this.getFile(), options);
        }
        catch (IOException ioe) {
            throw new RuntimeCamelException("Error opening LevelDB with file " + String.valueOf(this.getFile()), (Throwable)ioe);
        }
    }

    private DBFactory getFactory() {
        String[] classNames;
        for (String cn : classNames = new String[]{"org.fusesource.leveldbjni.JniDBFactory", "org.iq80.leveldb.impl.Iq80DBFactory"}) {
            try {
                Class clz = ObjectHelper.loadClass((String)cn, (ClassLoader)this.getClass().getClassLoader());
                DBFactory factory = (DBFactory)clz.newInstance();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using {} implementation of org.iq80.leveldb.DBFactory", (Object)factory.getClass().getName());
                }
                return factory;
            }
            catch (Throwable throwable) {
            }
        }
        throw new IllegalStateException("Can't find implementation of org.iq80.leveldb.DBFactory");
    }

    public void stop() {
        File file = this.getFile();
        LOG.debug("Stopping LevelDB using file: {}", (Object)file);
        if (this.db != null) {
            IOHelper.close((Closeable)this.db);
            this.db = null;
        }
    }
}

