/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.langchain4j.tools;

import dev.langchain4j.agent.tool.JsonSchemaProperty;
import dev.langchain4j.agent.tool.ToolSpecification;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.langchain4j.tools.LangChain4jToolsComponent;
import org.apache.camel.component.langchain4j.tools.LangChain4jToolsConfiguration;
import org.apache.camel.component.langchain4j.tools.LangChain4jToolsConsumer;
import org.apache.camel.component.langchain4j.tools.LangChain4jToolsProducer;
import org.apache.camel.component.langchain4j.tools.TagsHelper;
import org.apache.camel.component.langchain4j.tools.spec.CamelSimpleToolParameter;
import org.apache.camel.component.langchain4j.tools.spec.CamelToolExecutorCache;
import org.apache.camel.component.langchain4j.tools.spec.CamelToolSpecification;
import org.apache.camel.component.langchain4j.tools.spec.NamedJsonSchemaProperty;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.StringHelper;

@UriEndpoint(firstVersion="4.8.0", scheme="langchain4j-tools", title="LangChain4j Tools", syntax="langchain4j-tools:toolId", category={Category.AI})
public class LangChain4jToolsEndpoint
extends DefaultEndpoint {
    @Metadata(required=true)
    @UriPath(description="The tool name")
    private final String toolId;
    @Metadata(required=true)
    @UriParam(description="The tags for the tools")
    private String tags;
    @UriParam
    private LangChain4jToolsConfiguration configuration;
    @Metadata(label="consumer")
    @UriParam(description="Tool description")
    private String description;
    @Metadata(label="consumer")
    @UriParam(description="List of Tool parameters in the form of parameter.<name>=<type>", prefix="parameter.", multiValue=true)
    private Map<String, String> parameters;
    @Metadata(label="consumer,advanced")
    @UriParam(description="Tool's Camel Parameters, programmatically define Tool description and parameters")
    private CamelSimpleToolParameter camelToolParameter;

    public LangChain4jToolsEndpoint(String uri, LangChain4jToolsComponent component, String toolId, String tags, LangChain4jToolsConfiguration configuration) {
        super(uri, (Component)component);
        this.toolId = toolId;
        this.tags = tags;
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new LangChain4jToolsProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        String[] splitTags;
        ToolSpecification.Builder toolSpecificationBuilder = ToolSpecification.builder();
        if (this.camelToolParameter != null) {
            toolSpecificationBuilder.description(this.camelToolParameter.getDescription());
            for (NamedJsonSchemaProperty namedJsonSchemaProperty : this.camelToolParameter.getProperties()) {
                toolSpecificationBuilder.addParameter(namedJsonSchemaProperty.getName(), namedJsonSchemaProperty.getProperties());
            }
        } else if (this.description != null) {
            toolSpecificationBuilder.description(this.description);
            if (this.parameters != null) {
                this.parameters.forEach((name, type) -> toolSpecificationBuilder.addParameter(name, new JsonSchemaProperty[]{JsonSchemaProperty.type((String)type)}));
            }
        } else {
            throw new IllegalArgumentException("In order to use the langchain4j component as a consumer, you need to specify at least description, or a camelToolParameter");
        }
        String simpleDescription = null;
        if (this.description != null) {
            simpleDescription = StringHelper.dashToCamelCase((String)this.description.replace(" ", "-"));
        }
        ToolSpecification toolSpecification = toolSpecificationBuilder.name(simpleDescription).build();
        LangChain4jToolsConsumer langChain4jToolsConsumer = new LangChain4jToolsConsumer((Endpoint)this, processor);
        this.configureConsumer((Consumer)langChain4jToolsConsumer);
        CamelToolSpecification camelToolSpecification = new CamelToolSpecification(toolSpecification, langChain4jToolsConsumer);
        CamelToolExecutorCache executorCache = CamelToolExecutorCache.getInstance();
        for (String tag : splitTags = TagsHelper.splitTags(this.tags)) {
            executorCache.put(tag, camelToolSpecification);
        }
        return camelToolSpecification.getConsumer();
    }

    public String getToolId() {
        return this.toolId;
    }

    public LangChain4jToolsConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public CamelSimpleToolParameter getCamelToolParameter() {
        return this.camelToolParameter;
    }

    public void setCamelToolParameter(CamelSimpleToolParameter camelToolParameter) {
        this.camelToolParameter = camelToolParameter;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getTags() {
        return this.tags;
    }

    protected void doStop() throws Exception {
        super.doStop();
        CamelToolExecutorCache.getInstance().getTools().clear();
    }
}

