/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.langchain4j.tokenizer.util;

import dev.langchain4j.data.document.DocumentSplitter;
import dev.langchain4j.data.document.splitter.DocumentByCharacterSplitter;
import dev.langchain4j.data.document.splitter.DocumentByLineSplitter;
import dev.langchain4j.data.document.splitter.DocumentByParagraphSplitter;
import dev.langchain4j.data.document.splitter.DocumentBySentenceSplitter;
import dev.langchain4j.data.document.splitter.DocumentByWordSplitter;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.azure.AzureOpenAiTokenizer;
import dev.langchain4j.model.dashscope.QwenTokenizer;
import dev.langchain4j.model.openai.OpenAiTokenizer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.langchain4j.tokenizer.config.LangChain4JConfiguration;
import org.apache.camel.component.langchain4j.tokenizer.config.LangChain4JQwenConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SplitterUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SplitterUtil.class);

    private SplitterUtil() {
    }

    public static DocumentSplitter byName(String name, LangChain4JConfiguration configuration) {
        assert (name != null) : "The splitter name must be provided";
        int maxTokens = configuration.getMaxTokens();
        int maxOverlap = configuration.getMaxOverlap();
        String type = configuration.getType();
        Tokenizer tokenizer = SplitterUtil.buildTokenizer(configuration, type);
        LOG.debug("Creating a {} splitter", (Object)name);
        switch (name) {
            case "sentence": {
                return new DocumentBySentenceSplitter(maxTokens, maxOverlap, tokenizer);
            }
            case "paragraph": {
                return new DocumentByParagraphSplitter(maxTokens, maxOverlap, tokenizer);
            }
            case "character": {
                return new DocumentByCharacterSplitter(maxTokens, maxOverlap, tokenizer);
            }
            case "word": {
                return new DocumentByWordSplitter(maxTokens, maxOverlap, tokenizer);
            }
            case "line": {
                return new DocumentByLineSplitter(maxTokens, maxOverlap, tokenizer);
            }
        }
        throw new IllegalArgumentException("Unknown splitter name: " + name);
    }

    private static Tokenizer buildTokenizer(LangChain4JConfiguration configuration, String type) {
        if (type == null) {
            throw new RuntimeCamelException("Invalid tokenizer type: null");
        }
        return switch (type) {
            case "OPEN_AI" -> new OpenAiTokenizer();
            case "AZURE" -> new AzureOpenAiTokenizer();
            case "QWEN" -> SplitterUtil.createQwenTokenizer(configuration);
            default -> throw new RuntimeCamelException("Unknown tokenizer type: " + type);
        };
    }

    private static QwenTokenizer createQwenTokenizer(LangChain4JConfiguration configuration) {
        if (configuration instanceof LangChain4JQwenConfiguration) {
            LangChain4JQwenConfiguration qwenConfiguration = (LangChain4JQwenConfiguration)configuration;
            return new QwenTokenizer(qwenConfiguration.getApiKey(), qwenConfiguration.getModelName());
        }
        throw new RuntimeCamelException("Invalid configuration type for the QwenTokenizer: " + configuration.getClass().getSimpleName() + ". Use LangChain4JQwenConfiguration");
    }

    public static String[] split(DocumentSplitter splitter, String body) {
        if (splitter instanceof DocumentBySentenceSplitter) {
            DocumentBySentenceSplitter ds = (DocumentBySentenceSplitter)splitter;
            return ds.split(body);
        }
        if (splitter instanceof DocumentByParagraphSplitter) {
            DocumentByParagraphSplitter dp = (DocumentByParagraphSplitter)splitter;
            return dp.split(body);
        }
        if (splitter instanceof DocumentByCharacterSplitter) {
            DocumentByCharacterSplitter dc = (DocumentByCharacterSplitter)splitter;
            return dc.split(body);
        }
        if (splitter instanceof DocumentByWordSplitter) {
            DocumentByWordSplitter dw = (DocumentByWordSplitter)splitter;
            return dw.split(body);
        }
        if (splitter instanceof DocumentByLineSplitter) {
            DocumentByLineSplitter dl = (DocumentByLineSplitter)splitter;
            return dl.split(body);
        }
        throw new RuntimeCamelException("Unsupported splitter type: " + splitter.getClass().getSimpleName());
    }
}

