/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.langchain4j.chat;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.model.output.Response;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.component.langchain4j.chat.LangChain4jChatEndpoint;
import org.apache.camel.component.langchain4j.chat.LangChain4jChatOperations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;

public class LangChain4jChatProducer
extends DefaultProducer {
    private final LangChain4jChatEndpoint endpoint;
    private ChatLanguageModel chatLanguageModel;

    public LangChain4jChatProducer(LangChain4jChatEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        LangChain4jChatOperations operation = this.endpoint.getConfiguration().getChatOperation();
        if (LangChain4jChatOperations.CHAT_SINGLE_MESSAGE.equals((Object)operation)) {
            this.processSingleMessage(exchange);
        } else if (LangChain4jChatOperations.CHAT_SINGLE_MESSAGE_WITH_PROMPT.equals((Object)operation)) {
            this.processSingleMessageWithPrompt(exchange);
        } else if (LangChain4jChatOperations.CHAT_MULTIPLE_MESSAGES.equals((Object)operation)) {
            this.processMultipleMessages(exchange);
        }
    }

    private void processSingleMessageWithPrompt(Exchange exchange) throws NoSuchHeaderException, InvalidPayloadException {
        String promptTemplate = (String)exchange.getIn().getHeader("CamelLangChain4jChatPromptTemplate", String.class);
        if (promptTemplate == null) {
            throw new NoSuchHeaderException("The promptTemplate is a required header", exchange, "CamelLangChain4jChatPromptTemplate");
        }
        Map variables = (Map)exchange.getIn().getMandatoryBody(Map.class);
        String response = this.sendWithPromptTemplate(promptTemplate, variables);
        this.populateResponse(response, exchange);
    }

    private void processSingleMessage(Exchange exchange) throws InvalidPayloadException {
        Object message = exchange.getIn().getMandatoryBody();
        if (message instanceof String) {
            String text = (String)message;
            this.populateResponse(this.sendMessage(text), exchange);
        } else if (message instanceof ChatMessage) {
            ChatMessage chatMessage = (ChatMessage)message;
            this.populateResponse(this.sendChatMessage(chatMessage), exchange);
        }
    }

    private void processMultipleMessages(Exchange exchange) throws InvalidPayloadException {
        List messages = (List)exchange.getIn().getMandatoryBody(List.class);
        this.populateResponse(this.sendListChatMessage(messages), exchange);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.chatLanguageModel = this.endpoint.getConfiguration().getChatModel();
        ObjectHelper.notNull((Object)this.chatLanguageModel, (String)"chatLanguageModel");
    }

    private void populateResponse(String response, Exchange exchange) {
        exchange.getMessage().setBody((Object)response);
    }

    public String sendMessage(String message) {
        return this.chatLanguageModel.generate(message);
    }

    private String sendChatMessage(ChatMessage chatMessage) {
        Response response = this.chatLanguageModel.generate(new ChatMessage[]{chatMessage});
        return this.extractAiResponse((Response<AiMessage>)response);
    }

    private String sendListChatMessage(List<ChatMessage> chatMessages) {
        Response response = this.chatLanguageModel.generate(chatMessages);
        return this.extractAiResponse((Response<AiMessage>)response);
    }

    private String extractAiResponse(Response<AiMessage> response) {
        AiMessage message = (AiMessage)response.content();
        return message == null ? null : message.text();
    }

    public String sendWithPromptTemplate(String promptTemplate, Map<String, Object> variables) {
        PromptTemplate template = PromptTemplate.from((String)promptTemplate);
        Prompt prompt = template.apply(variables);
        return this.sendMessage(prompt.text());
    }
}

