/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.langchain.embeddings;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.output.Response;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.langchain.embeddings.LangChainEmbeddingsEndpoint;
import org.apache.camel.support.DefaultProducer;

public class LangChainEmbeddingsProducer
extends DefaultProducer {
    public LangChainEmbeddingsProducer(LangChainEmbeddingsEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public LangChainEmbeddingsEndpoint getEndpoint() {
        return (LangChainEmbeddingsEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        TextSegment in = (TextSegment)exchange.getMessage().getMandatoryBody(TextSegment.class);
        EmbeddingModel model = this.getEndpoint().getConfiguration().getEmbeddingModel();
        Response result = model.embed(in);
        Message message = exchange.getMessage();
        if (result.finishReason() != null) {
            message.setHeader("CamelLangChainEmbeddingsFinishReason", (Object)result.finishReason());
        }
        if (result.tokenUsage() != null) {
            message.setHeader("CamelLangChainEmbeddingsInputTokenCount", (Object)result.tokenUsage().inputTokenCount());
            message.setHeader("CamelLangChainEmbeddingsOutputTokenCount", (Object)result.tokenUsage().outputTokenCount());
            message.setHeader("CamelLangChainEmbeddingsTotalTokenCount", (Object)result.tokenUsage().totalTokenCount());
        }
        message.setHeader("CamelLangChainEmbeddingsVector", (Object)((Embedding)result.content()).vector());
    }
}

