/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kudu;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.kudu.KuduEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.kudu.client.KuduClient;

@Component(value="kudu")
public class KuduComponent
extends DefaultComponent {
    @Metadata(label="advanced", autowired=true)
    private KuduClient kuduClient;

    public KuduComponent(CamelContext context) {
        super(context);
    }

    public KuduComponent() {
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        KuduEndpoint endpoint = new KuduEndpoint(remaining, this);
        if (this.kuduClient != null) {
            endpoint.setKuduClient(this.kuduClient);
            endpoint.setUserManagedClient(true);
        }
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    public KuduClient getKuduClient() {
        return this.kuduClient;
    }

    public void setKuduClient(KuduClient kuduClient) {
        this.kuduClient = kuduClient;
    }
}

