/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kudu;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kudu.KuduEndpoint;
import org.apache.camel.component.kudu.KuduUtils;
import org.apache.camel.support.DefaultProducer;
import org.apache.kudu.Schema;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuduProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KuduProducer.class);
    private final KuduEndpoint endpoint;

    public KuduProducer(KuduEndpoint endpoint) {
        super((Endpoint)endpoint);
        if (endpoint == null || endpoint.getKuduClient() == null) {
            throw new IllegalArgumentException("Can't create a producer when the database connection is null");
        }
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        String table = this.endpoint.getTableName();
        switch (this.endpoint.getOperation()) {
            case INSERT: {
                this.doInsert(exchange, table);
                break;
            }
            case CREATE_TABLE: {
                this.doCreateTable(exchange, table);
                break;
            }
            case SCAN: {
                this.doScan(exchange, table);
                break;
            }
            default: {
                throw new IllegalArgumentException("The operation " + this.endpoint.getOperation() + " is not supported");
            }
        }
    }

    private void doInsert(Exchange exchange, String tableName) throws KuduException {
        LOG.trace("Insert on table {}", (Object)tableName);
        KuduClient connection = this.endpoint.getKuduClient();
        KuduTable table = connection.openTable(tableName);
        Insert insert = table.newInsert();
        PartialRow row = insert.getRow();
        Map rows = (Map)exchange.getIn().getBody(Map.class);
        for (Map.Entry entry : rows.entrySet()) {
            String colName = entry.getKey().toString();
            Object value = entry.getValue();
            if (table.getSchema().getColumn(colName) == null) continue;
            row.addObject(colName, value);
        }
        connection.newSession().apply((Operation)insert);
    }

    private void doCreateTable(Exchange exchange, String tableName) throws KuduException {
        LOG.trace("Creating table {}", (Object)tableName);
        KuduClient connection = this.endpoint.getKuduClient();
        Schema schema = (Schema)exchange.getIn().getHeader("CamelKuduSchema");
        CreateTableOptions builder = (CreateTableOptions)exchange.getIn().getHeader("CamelKuduTableOptions");
        connection.createTable(tableName, schema, builder);
    }

    private void doScan(Exchange exchange, String tableName) throws KuduException {
        exchange.getIn().setBody(KuduUtils.doScan(tableName, this.endpoint.getKuduClient()));
    }
}

