/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.properties;

import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.PropertiesFunction;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.LocationHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OrderedLocationProperties;
import org.apache.camel.util.SensitiveUtils;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BasePropertiesFunction
extends ServiceSupport
implements PropertiesFunction,
CamelContextAware {
    public static final String CLIENT_ENABLED = "camel.kubernetes-config.client-enabled";
    public static final String LOCAL_MODE = "camel.kubernetes-config.local-mode";
    public static final String MOUNT_PATH_CONFIGMAPS = "camel.kubernetes-config.mount-path-configmaps";
    public static final String MOUNT_PATH_SECRETS = "camel.kubernetes-config.mount-path-secrets";
    public static final String JVM_PROP_MOUNT_PATH_CONFIGMAPS = "camel.k.mount-path.configmaps";
    public static final String ENV_MOUNT_PATH_CONFIGMAPS = "CAMEL_K_MOUNT_PATH_CONFIGMAPS";
    public static final String JVM_PROP_MOUNT_PATH_SECRETS = "camel.k.mount-path.secrets";
    public static final String ENV_MOUNT_PATH_SECRETS = "CAMEL_K_MOUNT_PATH_SECRETS";
    private static final Logger LOG = LoggerFactory.getLogger(BasePropertiesFunction.class);
    private static final AtomicBoolean LOGGED = new AtomicBoolean();
    private CamelContext camelContext;
    private KubernetesClient client;
    private Boolean localMode;
    private Boolean clientEnabled;
    private String mountPathConfigMaps;
    private String mountPathSecrets;

    BasePropertiesFunction() {
    }

    protected void doInit() {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext");
        if (this.localMode == null) {
            this.localMode = "true".equalsIgnoreCase(this.camelContext.getPropertiesComponent().resolveProperty(LOCAL_MODE).orElse("false"));
        }
        if (!this.localMode.booleanValue()) {
            this.doInitKubernetesClient();
        }
    }

    protected void doInitKubernetesClient() {
        if (this.clientEnabled == null) {
            this.clientEnabled = "true".equalsIgnoreCase(this.camelContext.getPropertiesComponent().resolveProperty(CLIENT_ENABLED).orElse("true"));
        }
        if (this.mountPathConfigMaps == null) {
            this.mountPathConfigMaps = this.camelContext.getPropertiesComponent().resolveProperty(MOUNT_PATH_CONFIGMAPS).orElseGet(() -> System.getProperty(JVM_PROP_MOUNT_PATH_CONFIGMAPS, System.getenv(ENV_MOUNT_PATH_CONFIGMAPS)));
        }
        if (this.mountPathSecrets == null) {
            this.mountPathSecrets = this.camelContext.getPropertiesComponent().resolveProperty(MOUNT_PATH_SECRETS).orElseGet(() -> System.getProperty(JVM_PROP_MOUNT_PATH_SECRETS, System.getenv(ENV_MOUNT_PATH_SECRETS)));
        }
        if (this.clientEnabled.booleanValue() && this.client == null) {
            this.client = (KubernetesClient)CamelContextHelper.findSingleByType((CamelContext)this.camelContext, KubernetesClient.class);
        }
        if (this.clientEnabled.booleanValue() && this.client == null) {
            PropertiesComponent pc = this.camelContext.getPropertiesComponent();
            OrderedLocationProperties properties = (OrderedLocationProperties)pc.loadProperties(k -> k.startsWith("camel.kubernetes-config.client."), k -> k.replace("camel.kubernetes-config.client.", ""));
            if (!properties.isEmpty()) {
                ConfigBuilder config = new ConfigBuilder();
                PropertyConfigurer configurer = PluginHelper.getConfigurerResolver((CamelContext)this.camelContext).resolvePropertyConfigurer(ConfigBuilder.class.getName(), this.camelContext);
                OrderedLocationProperties copy = new OrderedLocationProperties();
                copy.putAll(properties);
                PropertyBindingSupport.build().withProperties(copy.asMap()).withFluentBuilder(true).withIgnoreCase(true).withReflection(false).withConfigurer(configurer).withTarget((Object)config).withCamelContext(this.camelContext).withRemoveParameters(true).bind();
                if (!copy.isEmpty()) {
                    for (Map.Entry e : copy.entrySet()) {
                        properties.remove(e.getKey());
                    }
                }
                this.client = new KubernetesClientBuilder().withConfig(config.build()).build();
                LOG.info("Auto-configuration KubernetesClient summary");
                for (Map.Entry entry : properties.entrySet()) {
                    String k2 = entry.getKey().toString();
                    Object v = entry.getValue();
                    String loc = LocationHelper.locationSummary((OrderedLocationProperties)properties, (String)k2);
                    if (SensitiveUtils.containsSensitive((String)k2)) {
                        LOG.info("    {} {}=xxxxxx", (Object)loc, (Object)k2);
                        continue;
                    }
                    LOG.info("    {} {}={}", new Object[]{loc, k2, v});
                }
                if (!copy.isEmpty()) {
                    for (Map.Entry e : copy.entrySet()) {
                        LOG.warn("Property not auto-configured: camel.kubernetes-config.client.{}={}", e.getKey(), e.getValue());
                    }
                }
            } else {
                this.client = new KubernetesClientBuilder().build();
                LOG.debug("Created default KubernetesClient (auto-configured by itself)");
            }
            this.camelContext.getRegistry().bind("camelKubernetesClient", (Object)this.client);
        }
        if (this.clientEnabled.booleanValue() && this.client == null && this.getMountPath() == null) {
            throw new IllegalArgumentException("Either a mount path or the Kubernetes Client must be configured");
        }
        if (!this.clientEnabled.booleanValue() && this.getMountPath() == null) {
            throw new IllegalArgumentException("Mount path must be configured");
        }
        if (this.client != null && LOGGED.compareAndSet(false, true)) {
            LOG.info("KubernetesClient using masterUrl: {} with namespace: {}", (Object)this.client.getMasterUrl(), (Object)this.client.getNamespace());
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public KubernetesClient getClient() {
        return this.client;
    }

    public void setClient(KubernetesClient client) {
        this.client = client;
    }

    public boolean isClientEnabled() {
        return this.clientEnabled;
    }

    public void setClientEnabled(boolean clientEnabled) {
        this.clientEnabled = clientEnabled;
    }

    public String getMountPathConfigMaps() {
        return this.mountPathConfigMaps;
    }

    public void setMountPathConfigMaps(String mountPathConfigMaps) {
        this.mountPathConfigMaps = mountPathConfigMaps;
    }

    public String getMountPathSecrets() {
        return this.mountPathSecrets;
    }

    public void setMountPathSecrets(String mountPathSecrets) {
        this.mountPathSecrets = mountPathSecrets;
    }

    public String apply(String remainder) {
        Path file;
        String defaultValue = StringHelper.after((String)remainder, (String)":");
        String name = StringHelper.before((String)remainder, (String)"/");
        String key = StringHelper.after((String)remainder, (String)"/");
        if (name == null || key == null) {
            return defaultValue;
        }
        if (key.contains(":")) {
            key = StringHelper.before((String)key, (String)":");
        }
        if (this.localMode.booleanValue()) {
            String localKey = name + "/" + key;
            return this.getCamelContext().getPropertiesComponent().resolveProperty(localKey).orElse(defaultValue);
        }
        String answer = null;
        Path root = this.getMountPath();
        if (root != null && Files.exists(file = root.resolve(name.toLowerCase(Locale.US)).resolve(key), new LinkOption[0]) && !Files.isDirectory(file, new LinkOption[0])) {
            try {
                answer = this.isBinaryProperty() ? this.writeDataToTempFile(file.getFileName().toString(), Files.readAllBytes(file)) : Files.readString(file, StandardCharsets.UTF_8);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (answer == null && this.client != null) {
            answer = this.lookup(name, key, defaultValue);
        }
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    abstract Path getMountPath();

    abstract String lookup(String var1, String var2, String var3);

    protected String handleData(String key, byte[] raw) {
        return this.isBinaryProperty() ? this.writeDataToTempFile(key, raw) : new String(raw);
    }

    private boolean isBinaryProperty() {
        return this.getName().endsWith("-binary");
    }

    protected String writeDataToTempFile(String fileName, byte[] data) {
        try {
            Path filePath = Files.createTempDirectory("camel", new FileAttribute[0]).resolve(fileName);
            Files.write(filePath, data, new OpenOption[0]);
            return filePath.toAbsolutePath().toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

