/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.job;

import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.JobFluent;
import io.fabric8.kubernetes.api.model.batch.v1.JobList;
import io.fabric8.kubernetes.api.model.batch.v1.JobSpec;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import io.fabric8.kubernetes.client.dsl.Updatable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesJobProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesJobProducer.class);

    public KubernetesJobProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = ObjectHelper.isEmpty((String)this.getEndpoint().getKubernetesConfiguration().getOperation()) ? (String)exchange.getIn().getHeader("CamelKubernetesOperation", String.class) : this.getEndpoint().getKubernetesConfiguration().getOperation();
        switch (operation) {
            case "listJob": {
                this.doList(exchange);
                break;
            }
            case "listJobByLabels": {
                this.doListJobByLabel(exchange);
                break;
            }
            case "getJob": {
                this.doGetJob(exchange);
                break;
            }
            case "createJob": {
                this.doCreateJob(exchange);
                break;
            }
            case "updateJob": {
                this.doUpdateJob(exchange);
                break;
            }
            case "deleteJob": {
                this.doDeleteJob(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange) {
        JobList jobList = (JobList)this.getEndpoint().getKubernetesClient().batch().v1().jobs().list();
        KubernetesHelper.prepareOutboundMessage(exchange, jobList.getItems());
    }

    protected void doListJobByLabel(Exchange exchange) {
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesJobLabels", Map.class);
        if (ObjectHelper.isEmpty((Map)labels)) {
            LOG.error("Get Job by labels require specify a labels set");
            throw new IllegalArgumentException("Get Job by labels require specify a labels set");
        }
        MixedOperation jobs = this.getEndpoint().getKubernetesClient().batch().v1().jobs();
        JobList jobList = (JobList)((FilterWatchListDeletable)jobs.withLabels(labels)).list();
        KubernetesHelper.prepareOutboundMessage(exchange, jobList.getItems());
    }

    protected void doGetJob(Exchange exchange) {
        String jobName = (String)exchange.getIn().getHeader("CamelKubernetesJobName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((String)jobName)) {
            LOG.error("Get a specific job require specify a job name");
            throw new IllegalArgumentException("Get a specific job require specify a job name");
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("Get a specific job require specify a namespace name");
            throw new IllegalArgumentException("Get a specific job require specify a namespace name");
        }
        Job job = (Job)((ScalableResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().batch().v1().jobs().inNamespace(namespaceName)).withName(jobName)).get();
        KubernetesHelper.prepareOutboundMessage(exchange, job);
    }

    protected void doUpdateJob(Exchange exchange) {
        this.doCreateOrUpdateJob(exchange, "Update", Updatable::update);
    }

    protected void doCreateJob(Exchange exchange) {
        this.doCreateOrUpdateJob(exchange, "Create", CreateOrReplaceable::create);
    }

    private void doCreateOrUpdateJob(Exchange exchange, String operationName, Function<Resource<Job>, Job> operation) {
        String jobName = (String)exchange.getIn().getHeader("CamelKubernetesJobName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        JobSpec jobSpec = (JobSpec)exchange.getIn().getHeader("CamelKubernetesJobSpec", JobSpec.class);
        HashMap annotations = (HashMap)exchange.getIn().getHeader("CamelKubernetesJobAnnotations", HashMap.class);
        if (ObjectHelper.isEmpty((String)jobName)) {
            LOG.error("{} a specific job require specify a job name", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific job require specify a job name", operationName));
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("{} a specific job require specify a namespace name", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific job require specify a namespace name", operationName));
        }
        if (ObjectHelper.isEmpty((Object)jobSpec)) {
            LOG.error("{} a specific job require specify a job spec bean", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific job require specify a job spec bean", operationName));
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesJobLabels", Map.class);
        JobBuilder jobCreatingBuilder = new JobBuilder();
        if (ObjectHelper.isEmpty((Map)annotations)) {
            ((JobBuilder)((JobFluent.MetadataNested)((JobFluent.MetadataNested)jobCreatingBuilder.withNewMetadata().withName(jobName)).withLabels(labels)).endMetadata()).withSpec(jobSpec);
        } else {
            ((JobBuilder)((JobFluent.MetadataNested)((JobFluent.MetadataNested)((JobFluent.MetadataNested)jobCreatingBuilder.withNewMetadata().withName(jobName)).withLabels(labels)).withAnnotations((Map)annotations)).endMetadata()).withSpec(jobSpec);
        }
        Job job = operation.apply((Resource<Job>)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().batch().v1().jobs().inNamespace(namespaceName)).resource((Object)jobCreatingBuilder.build())));
        KubernetesHelper.prepareOutboundMessage(exchange, job);
    }

    protected void doDeleteJob(Exchange exchange) {
        String jobName = (String)exchange.getIn().getHeader("CamelKubernetesJobName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((String)jobName)) {
            LOG.error("Delete a specific job require specify a job name");
            throw new IllegalArgumentException("Delete a specific job require specify a job name");
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("Delete a specific job require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific job require specify a namespace name");
        }
        ((ScalableResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().batch().v1().jobs().inNamespace(namespaceName)).withName(jobName)).delete();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getMessage(), (boolean)true);
    }
}

