/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.config_maps.vault;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.kubernetes.config_maps.vault.ConfigmapsReloadTriggerTask;
import org.apache.camel.component.kubernetes.properties.ConfigMapPropertiesFunction;
import org.apache.camel.spi.PeriodTaskScheduler;
import org.apache.camel.spi.PropertiesFunction;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.vault.KubernetesConfigMapVaultConfiguration;
import org.apache.camel.vault.KubernetesVaultConfiguration;

@DevConsole(name="kubernetes-configmaps", displayName="Kubernetes Config Maps", description="Kubernetes Cluster Config Maps")
public class ConfigmapsDevConsole
extends AbstractDevConsole {
    private ConfigMapPropertiesFunction propertiesFunction;
    private ConfigmapsReloadTriggerTask cmRefreshTask;

    public ConfigmapsDevConsole() {
        super("camel", "kubernetes-configmaps", "Kubernetes Config Maps", "Kubernetes Cluster Config Maps");
    }

    protected void doStart() throws Exception {
        KubernetesConfigMapVaultConfiguration kubernetes;
        PropertiesFunction pf;
        super.doStart();
        if (this.getCamelContext().getPropertiesComponent().hasPropertiesFunction("configmap") && (pf = this.getCamelContext().getPropertiesComponent().getPropertiesFunction("configmap")) instanceof ConfigMapPropertiesFunction) {
            this.propertiesFunction = (ConfigMapPropertiesFunction)pf;
        }
        if ((kubernetes = this.getCamelContext().getVaultConfiguration().getKubernetesConfigMapVaultConfiguration()) != null && kubernetes.isRefreshEnabled()) {
            PeriodTaskScheduler scheduler = PluginHelper.getPeriodTaskScheduler((CamelContext)this.getCamelContext());
            this.cmRefreshTask = (ConfigmapsReloadTriggerTask)scheduler.getTaskByType(ConfigmapsReloadTriggerTask.class);
        }
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        if (this.propertiesFunction != null) {
            sb.append("Kubernetes Config maps Cluster:");
            sb.append(String.format("\n    Master Url: %s", this.propertiesFunction.getClient().getMasterUrl()));
            sb.append("\n    Login: OAuth Token");
            KubernetesVaultConfiguration kubernetes = this.getCamelContext().getVaultConfiguration().getKubernetesVaultConfiguration();
            if (kubernetes != null) {
                sb.append(String.format("\n    Refresh Enabled: %s", kubernetes.isRefreshEnabled()));
            }
            if (this.cmRefreshTask != null) {
                Instant start = this.cmRefreshTask.getStartingTime();
                String s = start != null ? TimeUtils.printSince((long)start.toEpochMilli()) : "none";
                sb.append(String.format("\n    Running Since: %s", s));
            }
            ArrayList<Object> sorted = new ArrayList();
            if (kubernetes != null) {
                sb.append("\n\nSecrets in use:");
                sorted = new ArrayList<String>(List.of(kubernetes.getSecrets().split(",")));
                Collections.sort(sorted);
            }
            for (String sec : sorted) {
                sb.append(String.format("\n    %s", sec));
            }
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        Instant start;
        KubernetesVaultConfiguration kubernetes;
        JsonObject root = new JsonObject();
        if (this.propertiesFunction != null) {
            root.put((Object)"masterUrl", (Object)this.propertiesFunction.getClient().getMasterUrl().toString());
            root.put((Object)"login", (Object)"OAuth Token");
        }
        if ((kubernetes = this.getCamelContext().getVaultConfiguration().getKubernetesVaultConfiguration()) != null) {
            root.put((Object)"refreshEnabled", (Object)kubernetes.isRefreshEnabled());
        }
        if (this.cmRefreshTask != null && (start = this.cmRefreshTask.getStartingTime()) != null) {
            long timestamp = start.toEpochMilli();
            root.put((Object)"startCheckTimestamp", (Object)timestamp);
        }
        JsonArray arr = new JsonArray();
        root.put((Object)"configmaps", (Object)arr);
        ArrayList<String> sorted = new ArrayList<String>(List.of(kubernetes.getSecrets().split(",")));
        Collections.sort(sorted);
        for (String sec : sorted) {
            JsonObject jo = new JsonObject();
            jo.put((Object)"name", (Object)sec);
            arr.add((Object)jo);
        }
        return root;
    }
}

