/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.cloud;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.component.kubernetes.KubernetesConfiguration;
import org.apache.camel.component.kubernetes.cloud.KubernetesServiceDiscovery;
import org.apache.camel.impl.cloud.DefaultServiceDefinition;
import org.apache.camel.util.ObjectHelper;

@Deprecated
public class KubernetesDnsServiceDiscovery
extends KubernetesServiceDiscovery {
    private final ConcurrentMap<String, List<ServiceDefinition>> cache;
    private final String namespace;
    private final String zone;

    public KubernetesDnsServiceDiscovery(KubernetesConfiguration configuration) {
        super(configuration);
        this.namespace = configuration.getNamespace() != null ? configuration.getNamespace() : System.getenv("KUBERNETES_NAMESPACE");
        this.zone = configuration.getDnsDomain();
        ObjectHelper.notNull((Object)this.namespace, (String)"Namespace");
        ObjectHelper.notNull((Object)this.zone, (String)"DNS Domain");
        this.cache = new ConcurrentHashMap<String, List<ServiceDefinition>>();
    }

    public List<ServiceDefinition> getServices(String name) {
        return this.cache.computeIfAbsent(name, key -> Collections.singletonList(this.newService(name)));
    }

    private ServiceDefinition newService(String name) {
        return new DefaultServiceDefinition(name, name + "." + this.getConfiguration().getNamespace() + ".svc." + this.getConfiguration().getDnsDomain(), -1);
    }

    public String toString() {
        return "KubernetesDnsServiceDiscovery{namespace='" + this.namespace + "', zone='" + this.zone + "'}";
    }
}

