/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.customresources;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceList;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Replaceable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesCustomResourcesProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesCustomResourcesProducer.class);

    public KubernetesCustomResourcesProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = KubernetesHelper.extractOperation(this.getEndpoint(), exchange);
        String namespace = ObjectHelper.isEmpty((String)this.getEndpoint().getKubernetesConfiguration().getNamespace()) ? (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class) : this.getEndpoint().getKubernetesConfiguration().getNamespace();
        if (ObjectHelper.isEmpty((String)namespace)) {
            throw new IllegalArgumentException("Custom Resource producer requires a namespace argument");
        }
        switch (operation) {
            case "listCustomResources": {
                this.doList(exchange, namespace);
                break;
            }
            case "listCustomResourcesByLabels": {
                this.doListByLabels(exchange, namespace);
                break;
            }
            case "getCustomResource": {
                this.doGet(exchange, namespace);
                break;
            }
            case "deleteCustomResource": {
                this.doDelete(exchange, namespace);
                break;
            }
            case "createCustomResource": {
                this.doCreate(exchange, namespace);
                break;
            }
            case "updateCustomResource": {
                this.doUpdate(exchange, namespace);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange, String namespaceName) {
        CustomResourceDefinitionContext context = this.getCRDContext(exchange.getIn());
        GenericKubernetesResourceList list = (GenericKubernetesResourceList)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().genericKubernetesResources((ResourceDefinitionContext)context).inNamespace(namespaceName)).list();
        if (LOG.isDebugEnabled()) {
            LOG.debug(Serialization.asJson((Object)list));
        }
        JsonArray customResourcesListItems = list.getItems() != null ? new JsonArray((Collection)list.getItems()) : new JsonArray();
        KubernetesHelper.prepareOutboundMessage(exchange, customResourcesListItems);
    }

    protected void doListByLabels(Exchange exchange, String namespaceName) {
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesCRDLabels", Map.class);
        GenericKubernetesResourceList list = (GenericKubernetesResourceList)((FilterWatchListDeletable)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().genericKubernetesResources((ResourceDefinitionContext)this.getCRDContext(exchange.getIn())).inNamespace(namespaceName)).withLabels(labels)).list();
        if (LOG.isDebugEnabled()) {
            LOG.debug(Serialization.asJson((Object)list));
        }
        JsonArray customResourcesListItems = new JsonArray((Collection)list.getItems());
        KubernetesHelper.prepareOutboundMessage(exchange, customResourcesListItems);
    }

    protected void doGet(Exchange exchange, String namespaceName) {
        String customResourceName = (String)exchange.getIn().getHeader("CamelKubernetesCRDInstanceName", String.class);
        if (ObjectHelper.isEmpty((String)customResourceName)) {
            throw new IllegalArgumentException("Get a specific Deployment require specify a Deployment name");
        }
        JsonObject customResourceJSON = new JsonObject();
        try {
            customResourceJSON = new JsonObject((Map)((GenericKubernetesResource)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().genericKubernetesResources((ResourceDefinitionContext)this.getCRDContext(exchange.getIn())).inNamespace(namespaceName)).withName(customResourceName)).require()).get(new Object[0]));
        }
        catch (KubernetesClientException e) {
            if (e.getCode() == 404) {
                LOG.info("Custom resource instance not found", (Throwable)e);
            }
            throw e;
        }
        KubernetesHelper.prepareOutboundMessage(exchange, customResourceJSON);
    }

    protected void doDelete(Exchange exchange, String namespaceName) {
        String customResourceName = (String)exchange.getIn().getHeader("CamelKubernetesCRDInstanceName", String.class);
        if (ObjectHelper.isEmpty((String)customResourceName)) {
            LOG.error("Deleting a specific deployment require specify a deployment name");
            throw new IllegalArgumentException("Deleting a specific deployment require specify a deployment name");
        }
        try {
            List statusDetails = ((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().genericKubernetesResources((ResourceDefinitionContext)this.getCRDContext(exchange.getIn())).inNamespace(namespaceName)).withName(customResourceName)).delete();
            boolean deleted = ObjectHelper.isNotEmpty((Collection)statusDetails);
            exchange.getMessage().setHeader("CamelKubernetesDeleteResult", (Object)deleted);
        }
        catch (KubernetesClientException e) {
            if (e.getCode() == 404) {
                LOG.info("Custom resource instance not found", (Throwable)e);
            }
            throw e;
        }
    }

    protected void doUpdate(Exchange exchange, String namespaceName) {
        this.doCreateOrUpdate(exchange, namespaceName, Replaceable::update);
    }

    protected void doCreate(Exchange exchange, String namespaceName) {
        this.doCreateOrUpdate(exchange, namespaceName, CreateOrReplaceable::create);
    }

    private void doCreateOrUpdate(Exchange exchange, String namespaceName, Function<Resource<GenericKubernetesResource>, GenericKubernetesResource> operation) {
        String customResourceInstance = (String)exchange.getIn().getHeader("CamelKubernetesCRDInstance", String.class);
        GenericKubernetesResource customResource = new GenericKubernetesResource();
        try {
            customResource = operation.apply((Resource<GenericKubernetesResource>)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().genericKubernetesResources((ResourceDefinitionContext)this.getCRDContext(exchange.getIn())).inNamespace(namespaceName)).resource((Object)((GenericKubernetesResource)Serialization.unmarshal((String)customResourceInstance, GenericKubernetesResource.class)))));
        }
        catch (KubernetesClientException e) {
            if (e.getCode() == 409) {
                LOG.info("Custom resource instance already exists", (Throwable)e);
            }
            throw e;
        }
        KubernetesHelper.prepareOutboundMessage(exchange, customResource);
    }

    private CustomResourceDefinitionContext getCRDContext(Message message) {
        String name = ObjectHelper.isEmpty((String)this.getEndpoint().getKubernetesConfiguration().getCrdName()) ? (String)message.getHeader("CamelKubernetesCRDName", String.class) : this.getEndpoint().getKubernetesConfiguration().getCrdName();
        String group = ObjectHelper.isEmpty((String)this.getEndpoint().getKubernetesConfiguration().getCrdGroup()) ? (String)message.getHeader("CamelKubernetesCRDGroup", String.class) : this.getEndpoint().getKubernetesConfiguration().getCrdGroup();
        String scope = ObjectHelper.isEmpty((String)this.getEndpoint().getKubernetesConfiguration().getCrdScope()) ? (String)message.getHeader("CamelKubernetesCRDScope", String.class) : this.getEndpoint().getKubernetesConfiguration().getCrdScope();
        String version = ObjectHelper.isEmpty((String)this.getEndpoint().getKubernetesConfiguration().getCrdVersion()) ? (String)message.getHeader("CamelKubernetesCRDVersion", String.class) : this.getEndpoint().getKubernetesConfiguration().getCrdVersion();
        String plural = ObjectHelper.isEmpty((String)this.getEndpoint().getKubernetesConfiguration().getCrdPlural()) ? (String)message.getHeader("CamelKubernetesCRDPlural", String.class) : this.getEndpoint().getKubernetesConfiguration().getCrdPlural();
        if (ObjectHelper.isEmpty((String)name) || ObjectHelper.isEmpty((String)group) || ObjectHelper.isEmpty((String)scope) || ObjectHelper.isEmpty((String)version) || ObjectHelper.isEmpty((String)plural)) {
            LOG.error("one of more of the custom resource definition argument(s) are missing.");
            throw new IllegalArgumentException("one of more of the custom resource definition argument(s) are missing.");
        }
        return new CustomResourceDefinitionContext.Builder().withName((String)message.getHeader("CamelKubernetesCRDName", String.class)).withGroup((String)message.getHeader("CamelKubernetesCRDGroup", String.class)).withScope((String)message.getHeader("CamelKubernetesCRDScope", String.class)).withVersion((String)message.getHeader("CamelKubernetesCRDVersion", String.class)).withPlural((String)message.getHeader("CamelKubernetesCRDPlural", String.class)).build();
    }
}

