/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.config_maps;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Replaceable;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesConfigMapsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesConfigMapsProducer.class);

    public KubernetesConfigMapsProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = KubernetesHelper.extractOperation(this.getEndpoint(), exchange)) {
            case "listConfigMaps": {
                this.doList(exchange);
                break;
            }
            case "listConfigMapsByLabels": {
                this.doListConfigMapsByLabels(exchange);
                break;
            }
            case "getConfigMap": {
                this.doGetConfigMap(exchange);
                break;
            }
            case "createConfigMap": {
                this.doCreateConfigMap(exchange);
                break;
            }
            case "updateConfigMap": {
                this.doUpdateConfigMap(exchange);
                break;
            }
            case "deleteConfigMap": {
                this.doDeleteConfigMap(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange) {
        ConfigMapList configMapsList = (ConfigMapList)((AnyNamespaceOperation)this.getEndpoint().getKubernetesClient().configMaps().inAnyNamespace()).list();
        KubernetesHelper.prepareOutboundMessage(exchange, configMapsList.getItems());
    }

    protected void doListConfigMapsByLabels(Exchange exchange) {
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesConfigMapsLabels", Map.class);
        ConfigMapList configMapsList = (ConfigMapList)((FilterWatchListDeletable)((AnyNamespaceOperation)this.getEndpoint().getKubernetesClient().configMaps().inAnyNamespace()).withLabels(labels)).list();
        KubernetesHelper.prepareOutboundMessage(exchange, configMapsList.getItems());
    }

    protected void doGetConfigMap(Exchange exchange) {
        String cfMapName = (String)exchange.getIn().getHeader("CamelKubernetesConfigMapName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((String)cfMapName)) {
            LOG.error("Get a specific ConfigMap require specify a ConfigMap name");
            throw new IllegalArgumentException("Get a specific ConfigMap require specify a ConfigMap name");
        }
        ConfigMap configMap = namespaceName != null ? (ConfigMap)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().configMaps().inNamespace(namespaceName)).withName(cfMapName)).get() : (ConfigMap)((Resource)this.getEndpoint().getKubernetesClient().configMaps().withName(cfMapName)).get();
        KubernetesHelper.prepareOutboundMessage(exchange, configMap);
    }

    protected void doUpdateConfigMap(Exchange exchange) {
        this.doCreateOrUpdateConfigMap(exchange, "Update", Replaceable::update);
    }

    protected void doCreateConfigMap(Exchange exchange) {
        this.doCreateOrUpdateConfigMap(exchange, "Create", CreateOrReplaceable::create);
    }

    private void doCreateOrUpdateConfigMap(Exchange exchange, String operationName, Function<Resource<ConfigMap>, ConfigMap> operation) {
        String cfMapName = (String)exchange.getIn().getHeader("CamelKubernetesConfigMapName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        HashMap configMapData = (HashMap)exchange.getIn().getHeader("CamelKubernetesConfigData", HashMap.class);
        if (ObjectHelper.isEmpty((String)cfMapName)) {
            LOG.error("{} a specific configMap require specify a configMap name", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific configMap require specify a configMap name", operationName));
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("{} a specific configMap require specify a namespace name", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific configMap require specify a namespace name", operationName));
        }
        if (ObjectHelper.isEmpty((Map)configMapData)) {
            LOG.error("{} a specific configMap require specify a data map", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific configMap require specify a data map", operationName));
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesConfigMapsLabels", Map.class);
        ConfigMap cfMapCreating = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(cfMapName)).withLabels(labels)).endMetadata()).withData((Map)configMapData)).build();
        ConfigMap configMap = operation.apply((Resource<ConfigMap>)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().configMaps().inNamespace(namespaceName)).resource((Object)cfMapCreating)));
        KubernetesHelper.prepareOutboundMessage(exchange, configMap);
    }

    protected void doDeleteConfigMap(Exchange exchange) {
        String configMapName = (String)exchange.getIn().getHeader("CamelKubernetesConfigMapName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((String)configMapName)) {
            LOG.error("Delete a specific config map require specify a config map name");
            throw new IllegalArgumentException("Delete a specific config map require specify a config map name");
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("Delete a specific config map require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific config map require specify a namespace name");
        }
        List statusDetails = ((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().configMaps().inNamespace(namespaceName)).withName(configMapName)).delete();
        boolean cfMapDeleted = ObjectHelper.isNotEmpty((Collection)statusDetails);
        KubernetesHelper.prepareOutboundMessage(exchange, cfMapDeleted);
    }
}

