/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.namespaces;

import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Replaceable;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesNamespacesProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesNamespacesProducer.class);

    public KubernetesNamespacesProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = KubernetesHelper.extractOperation(this.getEndpoint(), exchange)) {
            case "listNamespaces": {
                this.doList(exchange);
                break;
            }
            case "listNamespacesByLabels": {
                this.doListNamespaceByLabel(exchange);
                break;
            }
            case "getNamespace": {
                this.doGetNamespace(exchange);
                break;
            }
            case "createNamespace": {
                this.doCreateNamespace(exchange);
                break;
            }
            case "replaceNamespace": {
                this.doReplaceNamespace(exchange);
                break;
            }
            case "deleteNamespace": {
                this.doDeleteNamespace(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange) {
        NamespaceList namespacesList = (NamespaceList)this.getEndpoint().getKubernetesClient().namespaces().list();
        KubernetesHelper.prepareOutboundMessage(exchange, namespacesList.getItems());
    }

    protected void doListNamespaceByLabel(Exchange exchange) {
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesNamespaceLabels", Map.class);
        if (ObjectHelper.isEmpty((Map)labels)) {
            LOG.error("Get a specific namespace by labels require specify a labels set");
            throw new IllegalArgumentException("Get a specific namespace by labels require specify a labels set");
        }
        NamespaceList namespace = (NamespaceList)((FilterWatchListDeletable)this.getEndpoint().getKubernetesClient().namespaces().withLabels(labels)).list();
        KubernetesHelper.prepareOutboundMessage(exchange, namespace.getItems());
    }

    protected void doGetNamespace(Exchange exchange) {
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("Get a specific namespace require specify a namespace name");
            throw new IllegalArgumentException("Get a specific namespace require specify a namespace name");
        }
        Namespace namespace = (Namespace)((Resource)this.getEndpoint().getKubernetesClient().namespaces().withName(namespaceName)).get();
        KubernetesHelper.prepareOutboundMessage(exchange, namespace);
    }

    protected void doReplaceNamespace(Exchange exchange) {
        this.doCreateOrUpdateNamespace(exchange, "Replace", Replaceable::replace);
    }

    protected void doCreateNamespace(Exchange exchange) {
        this.doCreateOrUpdateNamespace(exchange, "Create", CreateOrReplaceable::create);
    }

    private void doCreateOrUpdateNamespace(Exchange exchange, String operationName, Function<Resource<Namespace>, Namespace> operation) {
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("{} a specific namespace require specify a namespace name", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific namespace require specify a namespace name", operationName));
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesNamespaceLabels", Map.class);
        Namespace ns = ((NamespaceBuilder)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(namespaceName)).withLabels(labels)).endMetadata()).build();
        Namespace namespace = operation.apply((Resource<Namespace>)((Resource)this.getEndpoint().getKubernetesClient().namespaces().resource((Object)ns)));
        KubernetesHelper.prepareOutboundMessage(exchange, namespace);
    }

    protected void doDeleteNamespace(Exchange exchange) {
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("Delete a specific namespace require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific namespace require specify a namespace name");
        }
        List statusDetails = ((Resource)this.getEndpoint().getKubernetesClient().namespaces().withName(namespaceName)).delete();
        boolean namespaceDeleted = ObjectHelper.isNotEmpty((Collection)statusDetails);
        KubernetesHelper.prepareOutboundMessage(exchange, namespaceDeleted);
    }
}

