/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.events;

import io.fabric8.kubernetes.api.model.events.v1.Event;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesEventsConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesEventsConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private EventsConsumerTask eventWatcher;

    public KubernetesEventsConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.eventWatcher = new EventsConsumerTask();
        this.executor.submit(this.eventWatcher);
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Kubernetes Event Consumer");
        if (this.executor != null) {
            KubernetesHelper.close(this.eventWatcher, this.eventWatcher::getWatch);
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class EventsConsumerTask
    implements Runnable {
        private Watch watch;

        EventsConsumerTask() {
        }

        @Override
        public void run() {
            FilterWatchListDeletable w = null;
            if (ObjectHelper.isNotEmpty((String)KubernetesEventsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey()) && ObjectHelper.isNotEmpty((String)KubernetesEventsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue())) {
                w = (FilterWatchListDeletable)KubernetesEventsConsumer.this.getEndpoint().getKubernetesClient().events().v1().events().withLabel(KubernetesEventsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey(), KubernetesEventsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue());
            }
            if (ObjectHelper.isNotEmpty((String)KubernetesEventsConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName())) {
                Resource eventResource = (Resource)KubernetesEventsConsumer.this.getEndpoint().getKubernetesClient().events().v1().events().withName(KubernetesEventsConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName());
                w = (FilterWatchListDeletable)eventResource;
            }
            if (w == null) {
                throw new RuntimeCamelException("Consumer label key or consumer resource name need to be set.");
            }
            this.watch = w.watch((Watcher)new Watcher<Event>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void eventReceived(Watcher.Action action, Event resource) {
                    Exchange exchange = KubernetesEventsConsumer.this.createExchange(false);
                    exchange.getIn().setBody((Object)resource);
                    exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)action);
                    exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                    try {
                        KubernetesEventsConsumer.this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        KubernetesEventsConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                    }
                    finally {
                        KubernetesEventsConsumer.this.releaseExchange(exchange, false);
                    }
                }

                public void onClose(WatcherException cause) {
                    if (cause != null) {
                        LOG.error(cause.getMessage(), (Throwable)cause);
                    }
                }
            });
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

