/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.properties;

import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import org.apache.camel.component.kubernetes.properties.BasePropertiesFunction;
import org.apache.camel.spi.annotations.PropertiesFunction;

@PropertiesFunction(value="secret")
public class SecretPropertiesFunction
extends BasePropertiesFunction {
    public String getName() {
        return "secret";
    }

    @Override
    Path getMountPath() {
        if (this.getMountPathSecrets() != null) {
            return Paths.get(this.getMountPathSecrets(), new String[0]);
        }
        return null;
    }

    @Override
    String lookup(String name, String key, String defaultValue) {
        String answer = null;
        Secret sec = (Secret)((Resource)this.getClient().secrets().withName(name)).get();
        if (sec != null) {
            String string = answer = sec.getStringData() != null ? (String)sec.getStringData().get(key) : null;
            if (answer == null) {
                byte[] data;
                String string2 = answer = sec.getData() != null ? (String)sec.getData().get(key) : null;
                if (answer != null && (data = Base64.getDecoder().decode(answer)) != null) {
                    answer = new String(data);
                }
            }
        }
        if (answer == null) {
            return defaultValue;
        }
        return answer;
    }
}

