/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.cluster;

import java.net.InetAddress;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.kubernetes.KubernetesConfiguration;
import org.apache.camel.component.kubernetes.cluster.KubernetesClusterView;
import org.apache.camel.component.kubernetes.cluster.lock.KubernetesLockConfiguration;
import org.apache.camel.impl.cluster.AbstractCamelClusterService;
import org.apache.camel.util.ObjectHelper;

public class KubernetesClusterService
extends AbstractCamelClusterService<KubernetesClusterView> {
    private KubernetesConfiguration configuration;
    private KubernetesLockConfiguration lockConfiguration;

    public KubernetesClusterService() {
        this.configuration = new KubernetesConfiguration();
        this.lockConfiguration = new KubernetesLockConfiguration();
    }

    public KubernetesClusterService(KubernetesConfiguration configuration) {
        this.configuration = configuration.copy();
        this.lockConfiguration = new KubernetesLockConfiguration();
    }

    public KubernetesClusterService(CamelContext camelContext, KubernetesConfiguration configuration) {
        super(null, camelContext);
        this.configuration = configuration.copy();
        this.lockConfiguration = new KubernetesLockConfiguration();
    }

    protected KubernetesClusterView createView(String namespace) throws Exception {
        KubernetesLockConfiguration lockConfig = this.lockConfigWithGroupNameAndDefaults(namespace);
        KubernetesConfiguration config = this.setConfigDefaults(this.configuration.copy(), lockConfig);
        return new KubernetesClusterView(this.getCamelContext(), this, config, lockConfig);
    }

    protected KubernetesConfiguration setConfigDefaults(KubernetesConfiguration configuration, KubernetesLockConfiguration lockConfiguration) {
        if (configuration.getConnectionTimeout() == null) {
            int timeout = (int)(lockConfiguration.getRenewDeadlineMillis() / 3L);
            timeout = Math.max(timeout, 3000);
            timeout = Math.min(timeout, 30000);
            configuration.setConnectionTimeout(timeout);
        }
        return configuration;
    }

    protected KubernetesLockConfiguration lockConfigWithGroupNameAndDefaults(String groupName) {
        KubernetesLockConfiguration config = this.lockConfiguration.copy();
        config.setGroupName((String)ObjectHelper.notNull((Object)groupName, (String)"groupName"));
        if (config.getPodName() == null) {
            config.setPodName(System.getenv("HOSTNAME"));
            if (config.getPodName() == null) {
                try {
                    config.setPodName(InetAddress.getLocalHost().getHostName());
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Unable to determine pod name", (Throwable)e);
                }
            }
        }
        ObjectHelper.notNull((Object)config.getConfigMapName(), (String)"configMapName");
        ObjectHelper.notNull(config.getClusterLabels(), (String)"clusterLabels");
        if (config.getJitterFactor() < 1.0) {
            throw new IllegalStateException("jitterFactor must be >= 1 (found: " + config.getJitterFactor() + ")");
        }
        if (config.getRetryPeriodMillis() <= 0L) {
            throw new IllegalStateException("retryPeriodMillis must be > 0 (found: " + config.getRetryPeriodMillis() + ")");
        }
        if (config.getRenewDeadlineMillis() <= 0L) {
            throw new IllegalStateException("renewDeadlineMillis must be > 0 (found: " + config.getRenewDeadlineMillis() + ")");
        }
        if (config.getLeaseDurationMillis() <= 0L) {
            throw new IllegalStateException("leaseDurationMillis must be > 0 (found: " + config.getLeaseDurationMillis() + ")");
        }
        if (config.getLeaseDurationMillis() <= config.getRenewDeadlineMillis()) {
            throw new IllegalStateException("leaseDurationMillis must be greater than renewDeadlineMillis (" + config.getLeaseDurationMillis() + " is not greater than " + config.getRenewDeadlineMillis() + ")");
        }
        if ((double)config.getRenewDeadlineMillis() <= config.getJitterFactor() * (double)config.getRetryPeriodMillis()) {
            throw new IllegalStateException("renewDeadlineMillis must be greater than jitterFactor*retryPeriodMillis (" + config.getRenewDeadlineMillis() + " is not greater than " + config.getJitterFactor() + "*" + config.getRetryPeriodMillis() + ")");
        }
        return config;
    }

    public String getMasterUrl() {
        return this.configuration.getMasterUrl();
    }

    public void setMasterUrl(String masterUrl) {
        this.configuration.setMasterUrl(masterUrl);
    }

    public Integer getConnectionTimeoutMillis() {
        return this.configuration.getConnectionTimeout();
    }

    public void setConnectionTimeoutMillis(Integer connectionTimeout) {
        this.configuration.setConnectionTimeout(connectionTimeout);
    }

    public String getKubernetesNamespace() {
        return this.lockConfiguration.getKubernetesResourcesNamespace();
    }

    public void setKubernetesNamespace(String kubernetesNamespace) {
        this.lockConfiguration.setKubernetesResourcesNamespace(kubernetesNamespace);
    }

    public String getConfigMapName() {
        return this.lockConfiguration.getConfigMapName();
    }

    public void setConfigMapName(String configMapName) {
        this.lockConfiguration.setConfigMapName(configMapName);
    }

    public String getPodName() {
        return this.lockConfiguration.getPodName();
    }

    public void setPodName(String podName) {
        this.lockConfiguration.setPodName(podName);
    }

    public Map<String, String> getClusterLabels() {
        return this.lockConfiguration.getClusterLabels();
    }

    public void setClusterLabels(Map<String, String> clusterLabels) {
        this.lockConfiguration.setClusterLabels(clusterLabels);
    }

    public void addToClusterLabels(String key, String value) {
        this.lockConfiguration.addToClusterLabels(key, value);
    }

    public double getJitterFactor() {
        return this.lockConfiguration.getJitterFactor();
    }

    public void setJitterFactor(double jitterFactor) {
        this.lockConfiguration.setJitterFactor(jitterFactor);
    }

    public long getLeaseDurationMillis() {
        return this.lockConfiguration.getLeaseDurationMillis();
    }

    public void setLeaseDurationMillis(long leaseDurationMillis) {
        this.lockConfiguration.setLeaseDurationMillis(leaseDurationMillis);
    }

    public long getRenewDeadlineMillis() {
        return this.lockConfiguration.getRenewDeadlineMillis();
    }

    public void setRenewDeadlineMillis(long renewDeadlineMillis) {
        this.lockConfiguration.setRenewDeadlineMillis(renewDeadlineMillis);
    }

    public long getRetryPeriodMillis() {
        return this.lockConfiguration.getRetryPeriodMillis();
    }

    public void setRetryPeriodMillis(long retryPeriodMillis) {
        this.lockConfiguration.setRetryPeriodMillis(retryPeriodMillis);
    }
}

