/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kserve;

import com.google.protobuf.GeneratedMessageV3;
import inference.GRPCInferenceServiceGrpc;
import inference.GrpcPredictV2;
import java.util.Optional;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.kserve.KServeConfiguration;
import org.apache.camel.component.kserve.KServeEndpoint;
import org.apache.camel.support.DefaultProducer;

public class KServeProducer
extends DefaultProducer {
    private final String api;
    private final GRPCInferenceServiceGrpc.GRPCInferenceServiceBlockingStub inferenceService;

    public KServeProducer(KServeEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.api = endpoint.getApi();
        this.inferenceService = endpoint.getInferenceService();
    }

    public KServeEndpoint getEndpoint() {
        return (KServeEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) {
        GeneratedMessageV3 response = switch (this.api) {
            case "infer" -> this.infer(exchange);
            case "model/ready" -> this.modelReady(exchange);
            case "model/metadata" -> this.modelMetadata(exchange);
            case "server/ready" -> this.serverReady();
            case "server/live" -> this.serverLive();
            case "server/metadata" -> this.serverMetadata();
            default -> throw new IllegalArgumentException("Unsupported API: " + this.api);
        };
        exchange.getMessage().setBody((Object)response);
    }

    private GrpcPredictV2.ModelInferResponse infer(Exchange exchange) {
        Message message = exchange.getMessage();
        GrpcPredictV2.ModelInferRequest request = (GrpcPredictV2.ModelInferRequest)message.getBody(GrpcPredictV2.ModelInferRequest.class);
        KServeConfiguration configuration = this.getEndpoint().getConfiguration();
        GrpcPredictV2.ModelInferRequest.Builder builder = GrpcPredictV2.ModelInferRequest.newBuilder();
        Optional.ofNullable((String)message.getHeader("CamelKServeModelName", String.class)).or(() -> Optional.ofNullable(configuration.getModelName())).ifPresent(builder::setModelName);
        Optional.ofNullable((String)message.getHeader("CamelKServeModelVersion", String.class)).or(() -> Optional.ofNullable(configuration.getModelVersion())).ifPresent(builder::setModelVersion);
        if (request != null) {
            builder.mergeFrom(request);
        }
        return this.inferenceService.modelInfer(builder.build());
    }

    private GrpcPredictV2.ModelReadyResponse modelReady(Exchange exchange) {
        Message message = exchange.getMessage();
        GrpcPredictV2.ModelReadyRequest request = (GrpcPredictV2.ModelReadyRequest)message.getBody(GrpcPredictV2.ModelReadyRequest.class);
        KServeConfiguration configuration = this.getEndpoint().getConfiguration();
        GrpcPredictV2.ModelReadyRequest.Builder builder = GrpcPredictV2.ModelReadyRequest.newBuilder();
        Optional.ofNullable((String)message.getHeader("CamelKServeModelName", String.class)).or(() -> Optional.ofNullable(configuration.getModelName())).ifPresent(builder::setName);
        Optional.ofNullable((String)message.getHeader("CamelKServeModelVersion", String.class)).or(() -> Optional.ofNullable(configuration.getModelVersion())).ifPresent(builder::setVersion);
        if (request != null) {
            builder.mergeFrom(request);
        }
        return this.inferenceService.modelReady(builder.build());
    }

    private GrpcPredictV2.ModelMetadataResponse modelMetadata(Exchange exchange) {
        Message message = exchange.getMessage();
        GrpcPredictV2.ModelMetadataRequest request = (GrpcPredictV2.ModelMetadataRequest)message.getBody(GrpcPredictV2.ModelMetadataRequest.class);
        KServeConfiguration configuration = this.getEndpoint().getConfiguration();
        GrpcPredictV2.ModelMetadataRequest.Builder builder = GrpcPredictV2.ModelMetadataRequest.newBuilder();
        Optional.ofNullable((String)message.getHeader("CamelKServeModelName", String.class)).or(() -> Optional.ofNullable(configuration.getModelName())).ifPresent(builder::setName);
        Optional.ofNullable((String)message.getHeader("CamelKServeModelVersion", String.class)).or(() -> Optional.ofNullable(configuration.getModelVersion())).ifPresent(builder::setVersion);
        if (request != null) {
            builder.mergeFrom(request);
        }
        return this.inferenceService.modelMetadata(builder.build());
    }

    private GrpcPredictV2.ServerReadyResponse serverReady() {
        GrpcPredictV2.ServerReadyRequest.Builder builder = GrpcPredictV2.ServerReadyRequest.newBuilder();
        return this.inferenceService.serverReady(builder.build());
    }

    private GrpcPredictV2.ServerLiveResponse serverLive() {
        GrpcPredictV2.ServerLiveRequest.Builder builder = GrpcPredictV2.ServerLiveRequest.newBuilder();
        return this.inferenceService.serverLive(builder.build());
    }

    private GrpcPredictV2.ServerMetadataResponse serverMetadata() {
        GrpcPredictV2.ServerMetadataRequest.Builder builder = GrpcPredictV2.ServerMetadataRequest.newBuilder();
        return this.inferenceService.serverMetadata(builder.build());
    }
}

