/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.knative;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.knative.KnativeConfiguration;
import org.apache.camel.component.knative.KnativeEndpoint;
import org.apache.camel.component.knative.KnativeSupport;
import org.apache.camel.component.knative.spi.Knative;
import org.apache.camel.component.knative.spi.KnativeConsumerFactory;
import org.apache.camel.component.knative.spi.KnativeEnvironment;
import org.apache.camel.component.knative.spi.KnativeProducerFactory;
import org.apache.camel.component.knative.spi.KnativeResource;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.HealthCheckComponent;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="knative")
public class KnativeComponent
extends HealthCheckComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(KnativeComponent.class);
    @Metadata
    private KnativeConfiguration configuration;
    @Metadata
    private String environmentPath;
    @Metadata(defaultValue="http")
    private Knative.Protocol protocol = Knative.Protocol.http;
    @Metadata
    private KnativeProducerFactory producerFactory;
    @Metadata
    private KnativeConsumerFactory consumerFactory;

    public KnativeComponent() {
        this(null);
    }

    public KnativeComponent(CamelContext context) {
        super(context);
        this.configuration = new KnativeConfiguration();
        this.configuration.setTransportOptions(new HashMap<String, Object>());
    }

    public KnativeConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KnativeConfiguration configuration) {
        this.configuration = (KnativeConfiguration)ObjectHelper.notNull((Object)configuration, (String)"configuration");
    }

    public String getEnvironmentPath() {
        return this.environmentPath;
    }

    public void setEnvironmentPath(String environmentPath) {
        this.environmentPath = environmentPath;
    }

    public KnativeEnvironment getEnvironment() {
        return this.configuration.getEnvironment();
    }

    public void setEnvironment(KnativeEnvironment environment) {
        this.configuration.setEnvironment(environment);
    }

    public String getCloudEventsSpecVersion() {
        return this.configuration.getCloudEventsSpecVersion();
    }

    public void setCloudEventsSpecVersion(String cloudEventSpecVersion) {
        this.configuration.setCloudEventsSpecVersion(cloudEventSpecVersion);
    }

    public Knative.Protocol getProtocol() {
        return this.protocol;
    }

    public KnativeComponent setProtocol(Knative.Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public KnativeProducerFactory getProducerFactory() {
        return this.producerFactory;
    }

    public synchronized KnativeProducerFactory getOrCreateProducerFactory() throws Exception {
        if (this.producerFactory == null) {
            this.producerFactory = this.setUpProducerFactory();
        }
        return this.producerFactory;
    }

    public void setProducerFactory(KnativeProducerFactory producerFactory) {
        this.producerFactory = producerFactory;
    }

    public KnativeConsumerFactory getConsumerFactory() {
        return this.consumerFactory;
    }

    public synchronized KnativeConsumerFactory getOrCreateConsumerFactory() throws Exception {
        if (this.consumerFactory == null) {
            this.consumerFactory = this.setUpConsumerFactory();
        }
        return this.consumerFactory;
    }

    public void setConsumerFactory(KnativeConsumerFactory consumerFactory) {
        this.consumerFactory = consumerFactory;
    }

    public Map<String, Object> getTransportOptions() {
        return this.configuration.getTransportOptions();
    }

    public void setTransportOptions(Map<String, Object> transportOptions) {
        this.configuration.setTransportOptions(transportOptions);
    }

    protected void doInit() throws Exception {
        super.doInit();
        ServiceHelper.initService((Object[])new Object[]{this.consumerFactory, this.producerFactory});
    }

    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Object[])new Object[]{this.consumerFactory, this.producerFactory});
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Object[])new Object[]{this.consumerFactory, this.producerFactory});
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (ObjectHelper.isEmpty((String)remaining)) {
            throw new IllegalArgumentException("Expecting URI in the form of: 'knative:type/name', got '" + uri + "'");
        }
        String type = (String)ObjectHelper.supplyIfEmpty((Object)StringHelper.before((String)remaining, (String)"/"), () -> remaining);
        String name = StringHelper.after((String)remaining, (String)"/");
        KnativeConfiguration conf = this.getKnativeConfiguration();
        conf.getFilters().putAll(PropertiesHelper.extractProperties(parameters, (String)"filter.", (boolean)true));
        conf.getCeOverride().putAll(PropertiesHelper.extractProperties(parameters, (String)"ce.override.", (boolean)true));
        conf.getTransportOptions().putAll(PropertiesHelper.extractProperties(parameters, (String)"transport.", (boolean)true));
        KnativeEndpoint endpoint = new KnativeEndpoint(uri, this, Knative.Type.valueOf((String)type), name, conf);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    private KnativeConfiguration getKnativeConfiguration() throws Exception {
        String envConfig = System.getenv("CAMEL_KNATIVE_CONFIGURATION");
        KnativeConfiguration conf = this.configuration.copy();
        if (conf.getTransportOptions() == null) {
            conf.setTransportOptions(new HashMap<String, Object>());
        }
        if (conf.getFilters() == null) {
            conf.setFilters(new HashMap<String, String>());
        }
        if (conf.getCeOverride() == null) {
            conf.setCeOverride(new HashMap<String, String>());
        }
        if (conf.getEnvironment() == null) {
            KnativeEnvironment env = this.environmentPath != null ? KnativeEnvironment.mandatoryLoadFromResource((CamelContext)this.getCamelContext(), (String)this.environmentPath) : (envConfig != null ? (envConfig.startsWith("file:") || envConfig.startsWith("classpath:") ? KnativeEnvironment.mandatoryLoadFromResource((CamelContext)this.getCamelContext(), (String)envConfig) : KnativeEnvironment.mandatoryLoadFromSerializedString((String)envConfig)) : (KnativeEnvironment)CamelContextHelper.findSingleByType((CamelContext)this.getCamelContext(), KnativeEnvironment.class));
            conf.setEnvironment(env);
        }
        if (conf.getSinkBinding() != null) {
            if (conf.getEnvironment() == null) {
                conf.setEnvironment(new KnativeEnvironment());
            }
            KnativeResource sbRes = KnativeSupport.asResource(this.getCamelContext(), conf.getSinkBinding());
            conf.getEnvironment().getResources().add(sbRes);
        }
        if (conf.getEnvironment() == null) {
            throw new IllegalStateException("Cannot load Knative configuration from file or env variable");
        }
        return conf;
    }

    private KnativeProducerFactory setUpProducerFactory() throws Exception {
        if (this.producerFactory == null) {
            this.producerFactory = (KnativeProducerFactory)CamelContextHelper.lookup((CamelContext)this.getCamelContext(), (String)this.protocol.name(), KnativeProducerFactory.class);
            if (this.producerFactory == null) {
                this.producerFactory = (KnativeProducerFactory)this.getCamelContext().getCamelContextExtension().getBootstrapFactoryFinder("META-INF/services/org/apache/camel/knative/transport/").newInstance(this.protocol.name() + "-producer", KnativeProducerFactory.class).orElseThrow(() -> new IllegalArgumentException("Cannot create KnativeProducerFactory. Make sure camel-knative-http JAR is on classpath."));
                if (this.configuration.getTransportOptions() != null) {
                    this.setProperties(this.producerFactory, new HashMap<String, Object>(this.configuration.getTransportOptions()));
                }
                this.getCamelContext().addService((Object)this.producerFactory, true, true);
            }
            LOGGER.debug("Using Knative producer factory: {} for protocol: {}", (Object)this.producerFactory, (Object)this.protocol.name());
        }
        return this.producerFactory;
    }

    private KnativeConsumerFactory setUpConsumerFactory() throws Exception {
        if (this.consumerFactory == null) {
            this.consumerFactory = (KnativeConsumerFactory)CamelContextHelper.lookup((CamelContext)this.getCamelContext(), (String)this.protocol.name(), KnativeConsumerFactory.class);
            if (this.consumerFactory == null) {
                this.consumerFactory = (KnativeConsumerFactory)this.getCamelContext().getCamelContextExtension().getBootstrapFactoryFinder("META-INF/services/org/apache/camel/knative/transport/").newInstance(this.protocol.name() + "-consumer", KnativeConsumerFactory.class).orElseThrow(() -> new IllegalArgumentException("Cannot create KnativeConsumerFactory. Make sure camel-knative-http JAR is on classpath."));
                if (this.configuration.getTransportOptions() != null) {
                    this.setProperties(this.consumerFactory, new HashMap<String, Object>(this.configuration.getTransportOptions()));
                }
                this.getCamelContext().addService((Object)this.consumerFactory, true, true);
            }
            LOGGER.debug("Using Knative consumer factory: {} for protocol: {}", (Object)this.consumerFactory, (Object)this.protocol.name());
        }
        return this.consumerFactory;
    }
}

