/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.knative.http;

import io.vertx.ext.web.client.OAuth2WebClientOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.component.knative.http.KnativeSslClientOptions;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;

public class KnativeOidcClientOptions
extends KnativeSslClientOptions {
    private static final String PROPERTY_PREFIX = "camel.knative.client.oidc.";
    private final OAuth2WebClientOptions oAuth2ClientOptions = new OAuth2WebClientOptions().setRenewTokenOnForbidden(true);
    private boolean oidcEnabled;
    private String oidcTokenPath;
    private String oidcToken;
    private boolean cacheTokens = true;

    public KnativeOidcClientOptions() {
    }

    public KnativeOidcClientOptions(CamelContext camelContext) {
        super(camelContext);
    }

    @Override
    public void configureOptions(CamelContext camelContext) {
        super.configureOptions(camelContext);
        PropertiesComponent propertiesComponent = camelContext.getPropertiesComponent();
        boolean oidcEnabled = Boolean.parseBoolean(propertiesComponent.resolveProperty("camel.knative.client.oidc.enabled").orElse("false"));
        this.setOidcEnabled(oidcEnabled);
        if (oidcEnabled) {
            Optional oidcTokenPath = propertiesComponent.resolveProperty("camel.knative.client.oidc.token.path");
            oidcTokenPath.ifPresent(token -> {
                this.oidcTokenPath = token;
            });
            boolean renewTokenOnForbidden = Boolean.parseBoolean(propertiesComponent.resolveProperty("camel.knative.client.oidc.renew.tokens.on.forbidden").orElse("true"));
            this.oAuth2ClientOptions.setRenewTokenOnForbidden(renewTokenOnForbidden);
            boolean cacheTokens = Boolean.parseBoolean(propertiesComponent.resolveProperty("camel.knative.client.oidc.cache.tokens").orElse("true"));
            this.setCacheTokens(cacheTokens);
        }
    }

    public String retrieveOidcToken() {
        if (this.oidcToken == null || !this.cacheTokens) {
            try {
                this.oidcToken = IOHelper.loadText((InputStream)ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getCamelContext(), (String)this.oidcTokenPath)).trim();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.oidcToken;
    }

    public String renewOidcToken() {
        this.oidcToken = null;
        return this.retrieveOidcToken();
    }

    public void setOidcEnabled(boolean oidcEnabled) {
        this.oidcEnabled = oidcEnabled;
    }

    public boolean isOidcEnabled() {
        return this.oidcEnabled;
    }

    public void setCacheTokens(boolean cacheTokens) {
        this.cacheTokens = cacheTokens;
    }

    public boolean isCacheTokens() {
        return this.cacheTokens;
    }

    public void setOidcTokenPath(String oidcTokenPath) {
        this.oidcTokenPath = oidcTokenPath;
    }

    public String getOidcTokenPath() {
        return this.oidcTokenPath;
    }

    public void setRenewTokenOnForbidden(boolean enabled) {
        this.oAuth2ClientOptions.setRenewTokenOnForbidden(enabled);
    }

    public boolean isRenewTokenOnForbidden() {
        return this.oAuth2ClientOptions.isRenewTokenOnForbidden();
    }

    public OAuth2WebClientOptions getOAuth2ClientOptions() {
        return this.oAuth2ClientOptions;
    }
}

