/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kestrel;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.FailureMode;
import net.spy.memcached.MemcachedClient;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.kestrel.KestrelConfiguration;
import org.apache.camel.component.kestrel.KestrelEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KestrelComponent
extends DefaultComponent {
    private static final transient Logger LOG = LoggerFactory.getLogger(KestrelComponent.class);
    private KestrelConfiguration configuration;
    private ConnectionFactory memcachedConnectionFactory;
    private final Map<String, MemcachedClient> memcachedClientCache = new HashMap<String, MemcachedClient>();

    public KestrelComponent() {
        this.configuration = new KestrelConfiguration();
    }

    public KestrelComponent(KestrelConfiguration configuration) {
        this.configuration = configuration;
    }

    public KestrelComponent(CamelContext context) {
        super(context);
        this.configuration = new KestrelConfiguration();
    }

    protected void doStart() throws Exception {
        super.doStart();
        ConnectionFactoryBuilder builder = new ConnectionFactoryBuilder();
        builder.setShouldOptimize(false);
        builder.setOpTimeout(9999999L);
        builder.setFailureMode(FailureMode.Retry);
        this.memcachedConnectionFactory = builder.build();
    }

    public KestrelConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KestrelConfiguration configuration) {
        this.configuration = configuration;
    }

    protected KestrelEndpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        String queue;
        KestrelConfiguration config = this.getConfiguration().copy();
        URI u = new URI(uri);
        String[] addresses = null;
        if (u.getPath() == null || "".equals(u.getPath())) {
            queue = u.getAuthority();
        } else if (u.getAuthority() == null || "".equals(u.getAuthority())) {
            queue = u.getPath();
        } else {
            addresses = u.getAuthority().split(",");
            queue = u.getPath();
        }
        while (queue.startsWith("/")) {
            queue = queue.substring(1);
        }
        while (queue.endsWith("/")) {
            queue = queue.substring(0, queue.length() - 1);
        }
        if ("".equals(queue)) {
            throw new IllegalArgumentException("Queue not specified in endpoint URI: " + uri);
        }
        if (addresses != null && addresses.length > 0) {
            config.setAddresses(addresses);
        } else if (config.getAddresses() == null) {
            throw new IllegalArgumentException("Addresses not set in base configuration or endpoint: " + uri);
        }
        LOG.info("Creating endpoint for queue \"" + queue + "\" on " + config.getAddressesAsString() + ", parameters=" + parameters);
        this.setProperties(config, parameters);
        return new KestrelEndpoint(uri, this, config, queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemcachedClient getMemcachedClient(KestrelConfiguration config, String queue) {
        String key = config.getAddressesAsString() + "/" + queue;
        MemcachedClient memcachedClient = this.memcachedClientCache.get(key);
        if (memcachedClient != null) {
            return memcachedClient;
        }
        Map<String, MemcachedClient> map = this.memcachedClientCache;
        synchronized (map) {
            memcachedClient = this.memcachedClientCache.get(key);
            if (memcachedClient == null) {
                LOG.info("Creating MemcachedClient for " + key);
                try {
                    memcachedClient = new MemcachedClient(this.memcachedConnectionFactory, config.getInetSocketAddresses());
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Failed to connect to " + key, (Throwable)e);
                }
                this.memcachedClientCache.put(key, memcachedClient);
            }
        }
        return memcachedClient;
    }

    public void closeMemcachedClient(String key, MemcachedClient memcachedClient) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing client connection to " + key);
            }
            memcachedClient.shutdown();
            this.memcachedClientCache.remove(key);
        }
        catch (Exception e) {
            LOG.warn("Failed to close client connection to " + key, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doStop() throws Exception {
        HashMap<String, MemcachedClient> copy;
        Map<String, MemcachedClient> map = this.memcachedClientCache;
        synchronized (map) {
            copy = new HashMap<String, MemcachedClient>(this.memcachedClientCache);
            this.memcachedClientCache.clear();
        }
        for (Map.Entry entry : copy.entrySet()) {
            this.closeMemcachedClient((String)entry.getKey(), (MemcachedClient)entry.getValue());
        }
        super.doStop();
    }
}

