/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kestrel;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.RuntimeCamelException;

public class KestrelConfiguration
implements Cloneable {
    public static final int DEFAULT_KESTREL_PORT = 22133;
    private String[] addresses = new String[]{"localhost:22133"};
    private int waitTimeMs = 100;
    private int concurrentConsumers = 1;

    public String[] getAddresses() {
        return this.addresses;
    }

    public void setAddresses(String[] addresses) {
        this.addresses = addresses;
    }

    public int getWaitTimeMs() {
        return this.waitTimeMs;
    }

    public void setWaitTimeMs(int waitTimeMs) {
        this.waitTimeMs = waitTimeMs;
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        if (concurrentConsumers <= 0) {
            throw new IllegalArgumentException("Invalid value for concurrentConsumers: " + concurrentConsumers);
        }
        this.concurrentConsumers = concurrentConsumers;
    }

    public String getAddressesAsString() {
        StringBuilder bld = new StringBuilder();
        for (String address : this.addresses) {
            if (bld.length() > 0) {
                bld.append(',');
            }
            bld.append(address);
        }
        return bld.toString();
    }

    public List<InetSocketAddress> getInetSocketAddresses() {
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>();
        for (String address : this.addresses) {
            int port;
            String host;
            String[] tok = address.split(":");
            if (tok.length == 2) {
                host = tok[0];
                port = Integer.parseInt(tok[1]);
            } else if (tok.length == 1) {
                host = tok[0];
                port = 22133;
            } else {
                throw new IllegalArgumentException("Invalid address: " + address);
            }
            list.add(new InetSocketAddress(host, port));
        }
        return list;
    }

    public KestrelConfiguration copy() {
        try {
            return (KestrelConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

