/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kameletreify;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProducer;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.kameletreify.KameletReifyComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.service.ServiceHelper;

@UriEndpoint(firstVersion="3.6.0", scheme="kamelet-reify", syntax="kamelet-reify:delegateUri", title="Kamelet Reify", lenientProperties=true, category={Category.CORE})
public class KameletReifyEndpoint
extends DefaultEndpoint
implements DelegateEndpoint {
    @Metadata(required=true)
    @UriPath(description="The delegated uri")
    private final String delegateUri;
    private final Endpoint delegateEndpoint;

    public KameletReifyEndpoint(String uri, KameletReifyComponent component, String delegateUri) {
        super(uri, (Component)component);
        this.delegateUri = delegateUri;
        this.delegateEndpoint = component.getCamelContext().getEndpoint(delegateUri);
    }

    public String getDelegateUri() {
        return this.delegateUri;
    }

    public Endpoint getEndpoint() {
        return this.delegateEndpoint;
    }

    public KameletReifyComponent getComponent() {
        return (KameletReifyComponent)super.getComponent();
    }

    public boolean isLenientProperties() {
        return true;
    }

    public boolean isSingleton() {
        return false;
    }

    public Producer createProducer() throws Exception {
        return new KameletProducer();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        KemeletConsumer answer = new KemeletConsumer(processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.delegateEndpoint);
        super.doStart();
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.delegateEndpoint);
        super.doStart();
    }

    private class KameletProducer
    extends DefaultAsyncProducer {
        private volatile AsyncProducer producer;

        public KameletProducer() {
            super((Endpoint)KameletReifyEndpoint.this);
        }

        public boolean process(Exchange exchange, AsyncCallback callback) {
            if (this.producer != null) {
                return this.producer.process(exchange, callback);
            }
            callback.done(true);
            return true;
        }

        protected void doStart() throws Exception {
            this.producer = KameletReifyEndpoint.this.delegateEndpoint.createAsyncProducer();
            ServiceHelper.startService((Object)this.producer);
            super.doStart();
        }

        protected void doStop() throws Exception {
            ServiceHelper.stopService((Object)this.producer);
            super.doStop();
        }
    }

    private class KemeletConsumer
    extends DefaultConsumer {
        private volatile Consumer consumer;

        public KemeletConsumer(Processor processor) {
            super((Endpoint)KameletReifyEndpoint.this, processor);
        }

        protected void doStart() throws Exception {
            this.consumer = KameletReifyEndpoint.this.delegateEndpoint.createConsumer(this.getProcessor());
            ServiceHelper.startService((Object)this.consumer);
            super.doStart();
        }

        protected void doStop() throws Exception {
            ServiceHelper.stopService((Object)this.consumer);
            super.doStop();
        }
    }
}

