/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.dsl.support.DefaultSourceLoader;
import org.apache.camel.spi.Resource;

public class PackageNameSourceLoader
extends DefaultSourceLoader {
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("^\\s*package\\s+([a-zA-Z][.\\w]*)\\s*;.*$", 8);
    private final String packageName;

    public PackageNameSourceLoader(String packageName) {
        this.packageName = packageName;
    }

    public String loadResource(Resource resource) throws IOException {
        String pn;
        Object code = super.loadResource(resource);
        String loc = resource.getLocation();
        if (loc != null && loc.endsWith(".java") && (pn = PackageNameSourceLoader.determineClassName((String)code)) == null) {
            code = "package " + this.packageName + "; " + (String)code;
        }
        return code;
    }

    private static String determineClassName(String content) {
        Matcher matcher = PACKAGE_PATTERN.matcher(content);
        return matcher.find() ? matcher.group(1) : null;
    }
}

