/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import org.apache.camel.CamelContext;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.impl.engine.DefaultUriFactoryResolver;
import org.apache.camel.main.download.DependencyDownloader;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.tooling.model.ComponentModel;

public class DependencyDownloaderUriFactoryResolver
extends DefaultUriFactoryResolver {
    private final CamelCatalog catalog = new DefaultCamelCatalog();
    private final DependencyDownloader downloader;

    public DependencyDownloaderUriFactoryResolver(CamelContext camelContext) {
        this.downloader = (DependencyDownloader)camelContext.hasService(DependencyDownloader.class);
    }

    public EndpointUriFactory resolveFactory(String name, CamelContext context) {
        ComponentModel model = this.catalog.componentModel(name);
        if (model != null && !this.downloader.alreadyOnClasspath(model.getGroupId(), model.getArtifactId(), model.getVersion())) {
            this.downloader.downloadDependency(model.getGroupId(), model.getArtifactId(), model.getVersion());
        }
        return super.resolveFactory(name, context);
    }
}

