/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesFunctionResolver;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.engine.DefaultCompileStrategy;
import org.apache.camel.main.MainCommandLineSupport;
import org.apache.camel.main.MainConfigurationProperties;
import org.apache.camel.main.MainRegistry;
import org.apache.camel.main.download.AutoConfigureDownloadListener;
import org.apache.camel.main.download.BasePackageScanDownloadListener;
import org.apache.camel.main.download.CamelCustomClassLoader;
import org.apache.camel.main.download.CircuitBreakerDownloader;
import org.apache.camel.main.download.CommandLineDependencyDownloader;
import org.apache.camel.main.download.DependencyDownloaderClassLoader;
import org.apache.camel.main.download.DependencyDownloaderClassResolver;
import org.apache.camel.main.download.DependencyDownloaderComponentResolver;
import org.apache.camel.main.download.DependencyDownloaderDataFormatResolver;
import org.apache.camel.main.download.DependencyDownloaderKamelet;
import org.apache.camel.main.download.DependencyDownloaderLanguageResolver;
import org.apache.camel.main.download.DependencyDownloaderPropertiesFunctionResolver;
import org.apache.camel.main.download.DependencyDownloaderPropertyBindingListener;
import org.apache.camel.main.download.DependencyDownloaderResourceLoader;
import org.apache.camel.main.download.DependencyDownloaderRoutesLoader;
import org.apache.camel.main.download.DependencyDownloaderStrategy;
import org.apache.camel.main.download.DependencyDownloaderTransformerResolver;
import org.apache.camel.main.download.DependencyDownloaderUriFactoryResolver;
import org.apache.camel.main.download.DownloadListener;
import org.apache.camel.main.download.DownloadModelineParser;
import org.apache.camel.main.download.KameletAutowiredLifecycleStrategy;
import org.apache.camel.main.download.KameletMainInjector;
import org.apache.camel.main.download.KnownDependenciesResolver;
import org.apache.camel.main.download.KnownReposResolver;
import org.apache.camel.main.download.MavenDependencyDownloader;
import org.apache.camel.main.download.PackageNameSourceLoader;
import org.apache.camel.main.download.PromptPropertyPlaceholderSource;
import org.apache.camel.main.download.StubBeanRepository;
import org.apache.camel.main.download.TypeConverterLoaderDownloadListener;
import org.apache.camel.main.injection.AnnotationDependencyInjection;
import org.apache.camel.main.reload.OpenApiGeneratorReloadStrategy;
import org.apache.camel.main.util.ClipboardReloadStrategy;
import org.apache.camel.main.util.ExtraClassesClassLoader;
import org.apache.camel.main.util.ExtraFilesClassLoader;
import org.apache.camel.main.xml.blueprint.BlueprintXmlBeansHandler;
import org.apache.camel.main.xml.spring.SpringXmlBeansHandler;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.CliConnector;
import org.apache.camel.spi.CliConnectorFactory;
import org.apache.camel.spi.CompileStrategy;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.PeriodTaskScheduler;
import org.apache.camel.spi.PropertiesSource;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.ResourceLoader;
import org.apache.camel.spi.RoutesLoader;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.spi.TransformerResolver;
import org.apache.camel.spi.UriFactoryResolver;
import org.apache.camel.startup.jfr.FlightRecorderStartupStepRecorder;
import org.apache.camel.support.DefaultContextReloadStrategy;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.RouteOnDemandReloadStrategy;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.startup.BacklogStartupStepRecorder;
import org.apache.camel.tooling.maven.MavenGav;
import org.w3c.dom.Document;

public class KameletMain
extends MainCommandLineSupport {
    public static final String DEFAULT_KAMELETS_LOCATION = "classpath:/kamelets,github:apache:camel-kamelets/kamelets";
    protected final MainRegistry registry = new MainRegistry(new BeanRepository[0]);
    private String profile = "dev";
    private boolean download = true;
    private String repos;
    private boolean fresh;
    private boolean verbose;
    private String mavenSettings;
    private String mavenSettingsSecurity;
    boolean mavenCentralEnabled = true;
    boolean mavenApacheSnapshotEnabled = true;
    private String stubPattern;
    private boolean silent;
    private DownloadListener downloadListener;
    private DependencyDownloaderClassLoader classLoader;
    private final SpringXmlBeansHandler springXmlBeansHandler = new SpringXmlBeansHandler();
    private final BlueprintXmlBeansHandler blueprintXmlBeansHandler = new BlueprintXmlBeansHandler();

    public KameletMain() {
        this.configureInitialProperties(DEFAULT_KAMELETS_LOCATION);
    }

    public KameletMain(String overrides) {
        Objects.requireNonNull(overrides);
        String locations = overrides + ",classpath:/kamelets,github:apache:camel-kamelets/kamelets";
        this.configureInitialProperties(locations);
    }

    public static void main(String ... args) throws Exception {
        KameletMain main = new KameletMain();
        int code = main.run(args);
        if (code != 0) {
            System.exit(code);
        }
    }

    public void bind(String name, Object bean) {
        this.registry.bind(name, bean);
    }

    public Object lookup(String name) {
        return this.registry.lookupByName(name);
    }

    public <T> T lookup(String name, Class<T> type) {
        return (T)this.registry.lookupByNameAndType(name, type);
    }

    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.registry.findByTypeWithName(type);
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public boolean isDownload() {
        return this.download;
    }

    public void setDownload(boolean download) {
        this.download = download;
    }

    public String getRepos() {
        return this.repos;
    }

    public void setRepos(String repos) {
        this.repos = repos;
    }

    public boolean isFresh() {
        return this.fresh;
    }

    public void setFresh(boolean fresh) {
        this.fresh = fresh;
    }

    public void setStubPattern(String stubPattern) {
        this.stubPattern = stubPattern;
    }

    public String getStubPattern() {
        return this.stubPattern;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public void setMavenSettings(String mavenSettings) {
        this.mavenSettings = mavenSettings;
    }

    public String getMavenSettings() {
        return this.mavenSettings;
    }

    public void setMavenSettingsSecurity(String mavenSettingsSecurity) {
        this.mavenSettingsSecurity = mavenSettingsSecurity;
    }

    public String getMavenSettingsSecurity() {
        return this.mavenSettingsSecurity;
    }

    public DownloadListener getDownloadListener() {
        return this.downloadListener;
    }

    public boolean isMavenCentralEnabled() {
        return this.mavenCentralEnabled;
    }

    public void setMavenCentralEnabled(boolean mavenCentralEnabled) {
        this.mavenCentralEnabled = mavenCentralEnabled;
    }

    public boolean isMavenApacheSnapshotEnabled() {
        return this.mavenApacheSnapshotEnabled;
    }

    public void setMavenApacheSnapshotEnabled(boolean mavenApacheSnapshotEnabled) {
        this.mavenApacheSnapshotEnabled = mavenApacheSnapshotEnabled;
    }

    public void setDownloadListener(DownloadListener downloadListener) {
        this.downloadListener = downloadListener;
    }

    public void showOptionsHeader() {
        System.out.println("Apache Camel (KameletMain) takes the following options");
        System.out.println();
    }

    protected void addInitialOptions() {
        this.addOption(new MainCommandLineSupport.Option("h", "help", "Displays the help screen"){

            protected void doProcess(String arg, LinkedList<String> remainingArgs) {
                KameletMain.this.showOptions();
                KameletMain.this.completed();
            }
        });
        this.addOption((MainCommandLineSupport.Option)new MainCommandLineSupport.ParameterOption("download", "download", "Whether to allow automatic downloaded JAR dependencies, over the internet.", "download"){

            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                if (arg.equals("-download")) {
                    KameletMain.this.setDownload("true".equalsIgnoreCase(parameter));
                }
            }
        });
        this.addOption((MainCommandLineSupport.Option)new MainCommandLineSupport.ParameterOption("repos", "repositories", "Additional maven repositories for download on-demand.", "repos"){

            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                if (arg.equals("-repos")) {
                    KameletMain.this.setRepos(parameter);
                }
            }
        });
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.initCamelContext();
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.getCamelContext() != null) {
            try {
                this.getCamelContext().start();
            }
            finally {
                if (this.getCamelContext().isVetoStarted()) {
                    this.completed();
                }
            }
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.getCamelContext() != null) {
            this.getCamelContext().stop();
        }
        this.springXmlBeansHandler.stop();
        this.blueprintXmlBeansHandler.stop();
    }

    protected ProducerTemplate findOrCreateCamelTemplate() {
        if (this.getCamelContext() != null) {
            return this.getCamelContext().createProducerTemplate();
        }
        return null;
    }

    protected CamelContext createCamelContext() {
        MavenGav g;
        String gav;
        boolean transform;
        boolean ignoreLoading;
        boolean metrics;
        boolean health;
        boolean infoConsole;
        boolean tracing;
        boolean console;
        CliConnectorFactory ccf;
        String info;
        this.verbose = "true".equals(this.getInitialProperties().get("camel.jbang.verbose"));
        DefaultCamelContext answer = new DefaultCamelContext(false);
        answer.getCamelContextExtension().setStartupStepRecorder((StartupStepRecorder)new BacklogStartupStepRecorder());
        boolean prompt = "true".equals(this.getInitialProperties().get("camel.jbang.prompt"));
        if (prompt) {
            answer.getPropertiesComponent().addPropertiesSource((PropertiesSource)new PromptPropertyPlaceholderSource());
        }
        ClassLoader dynamicCL = this.createApplicationContextClassLoader((CamelContext)answer);
        answer.setApplicationContextClassLoader(dynamicCL);
        PluginHelper.getPackageScanClassResolver((CamelContext)answer).addClassLoader(dynamicCL);
        PluginHelper.getPackageScanResourceResolver((CamelContext)answer).addClassLoader(dynamicCL);
        KnownReposResolver knownRepos = new KnownReposResolver();
        knownRepos.loadKnownDependencies();
        MavenDependencyDownloader downloader = new MavenDependencyDownloader();
        downloader.setDownload(this.download);
        downloader.setKnownReposResolver(knownRepos);
        downloader.setClassLoader(dynamicCL);
        downloader.setCamelContext((CamelContext)answer);
        downloader.setVerbose(this.verbose);
        downloader.setRepos(this.repos);
        downloader.setFresh(this.fresh);
        downloader.setMavenSettings(this.mavenSettings);
        downloader.setMavenSettingsSecurity(this.mavenSettingsSecurity);
        downloader.setMavenCentralEnabled(this.mavenCentralEnabled);
        downloader.setMavenApacheSnapshotEnabled(this.mavenApacheSnapshotEnabled);
        if (this.downloadListener != null) {
            downloader.addDownloadListener(this.downloadListener);
        }
        downloader.addDownloadListener(new AutoConfigureDownloadListener());
        downloader.addArtifactDownloadListener(new TypeConverterLoaderDownloadListener());
        downloader.addArtifactDownloadListener(new BasePackageScanDownloadListener());
        try {
            answer.addService((Object)downloader);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
        }
        CircuitBreakerDownloader.registerDownloadReifiers();
        if (this.silent || "*".equals(this.stubPattern)) {
            this.mainConfigurationProperties.setAutowiredEnabled(false);
            this.mainConfigurationProperties.setAutoConfigurationFailFast(false);
        }
        if ((info = this.startupInfo()) != null) {
            LOG.info(info);
        }
        answer.getCamelContextExtension().setRegistry((Registry)this.registry);
        if (this.silent || "*".equals(this.stubPattern)) {
            this.registry.addBeanRepository((BeanRepository)new StubBeanRepository(this.stubPattern));
        }
        answer.setLoadHealthChecks(Boolean.valueOf(true));
        AnnotationDependencyInjection.initAnnotationBasedDependencyInjection((CamelContext)answer);
        if (!this.silent && answer.hasService(CliConnector.class) == null && (ccf = (CliConnectorFactory)answer.getCamelContextExtension().getContextPlugin(CliConnectorFactory.class)) != null && ccf.isEnabled()) {
            CliConnector connector = ccf.createConnector();
            try {
                answer.addService((Object)connector, true);
                ServiceHelper.startService((Service)connector);
            }
            catch (Exception e) {
                LOG.warn("Cannot start camel-cli-connector due: {}. This integration cannot be managed by Camel CLI.", (Object)e.getMessage());
            }
        }
        this.configure().withProfile(this.profile);
        Object port = this.getInitialProperties().get("camel.jbang.platform-http.port");
        if (port != null) {
            this.configure().httpServer().withEnabled(true);
            this.configure().httpServer().withPort(Integer.parseInt(port.toString()));
        }
        if (console = "true".equals(this.getInitialProperties().get("camel.jbang.console"))) {
            this.configure().setDevConsoleEnabled(true);
            this.configure().httpServer().withEnabled(true);
            this.configure().httpServer().withInfoEnabled(true);
            this.configure().httpServer().withDevConsoleEnabled(true);
        }
        if (tracing = "true".equals(this.getInitialProperties().get("camel.jbang.backlogTracing"))) {
            this.configure().tracerConfig().withEnabled(true);
        }
        if (infoConsole = "true".equals(this.getInitialProperties().get("camel.jbang.info"))) {
            this.configure().httpServer().withEnabled(true);
            this.configure().httpServer().withInfoEnabled(true);
        }
        if (health = "true".equals(this.getInitialProperties().get("camel.jbang.health"))) {
            this.configure().health().withEnabled(true);
            this.configure().httpServer().withEnabled(true);
            this.configure().httpServer().withHealthCheckEnabled(true);
        }
        if (metrics = "true".equals(this.getInitialProperties().get("camel.jbang.metrics"))) {
            this.configure().metrics().witheEnableRouteEventNotifier(true).withEnableMessageHistory(true).withEnableExchangeEventNotifier(true).withEnableRoutePolicy(true).withEnabled(true);
            this.configure().httpServer().withEnabled(true);
            this.configure().httpServer().withMetricsEnabled(true);
        }
        if (ignoreLoading = "true".equals(this.getInitialProperties().get("camel.jbang.ignoreLoadingError"))) {
            this.configure().withRoutesCollectorIgnoreLoadingError(true);
        }
        if (transform = "true".equals(this.getInitialProperties().get("camel.jbang.transform"))) {
            answer.getGlobalOptions().put("DisableAllProcessors", "true");
            this.blueprintXmlBeansHandler.setTransform(true);
        }
        if (this.silent) {
            this.configure().httpServer().withEnabled(false);
        }
        Object jfr = this.getInitialProperties().get("camel.jbang.jfr");
        Object jfrProfile = this.getInitialProperties().get("camel.jbang.jfr-profile");
        if ("jfr".equals(jfr) || jfrProfile != null) {
            FlightRecorderStartupStepRecorder recorder = new FlightRecorderStartupStepRecorder();
            recorder.setRecording(true);
            if (jfrProfile != null) {
                recorder.setRecordingProfile(jfrProfile.toString());
            }
            answer.getCamelContextExtension().setStartupStepRecorder((StartupStepRecorder)recorder);
        }
        if ((gav = this.getInitialProperties().getProperty("camel.jbang.gav")) != null && (g = MavenGav.parseGav((String)gav)).getGroupId() != null && g.getArtifactId() != null) {
            String defaultPackageName = g.getGroupId().replace('-', '.') + "." + g.getArtifactId().replace('-', '.');
            PackageNameSourceLoader sl = new PackageNameSourceLoader(defaultPackageName);
            answer.getRegistry().bind("PackageNameSourceLoader", (Object)sl);
        }
        String sourceDir = this.getInitialProperties().getProperty("camel.jbang.sourceDir");
        try {
            Object dependencies = this.getInitialProperties().get("camel.jbang.dependencies");
            if (dependencies != null) {
                answer.addService((Object)new CommandLineDependencyDownloader((CamelContext)answer, dependencies.toString()));
            }
            KnownDependenciesResolver knownDeps = new KnownDependenciesResolver((CamelContext)answer);
            knownDeps.loadKnownDependencies();
            DependencyDownloaderPropertyBindingListener listener = new DependencyDownloaderPropertyBindingListener((CamelContext)answer, knownDeps);
            answer.getCamelContextExtension().getRegistry().bind(DependencyDownloaderPropertyBindingListener.class.getSimpleName(), (Object)listener);
            answer.getCamelContextExtension().getRegistry().bind(DependencyDownloaderStrategy.class.getSimpleName(), (Object)new DependencyDownloaderStrategy((CamelContext)answer));
            DependencyDownloaderClassResolver classResolver = new DependencyDownloaderClassResolver((CamelContext)answer, knownDeps, this.silent);
            answer.setClassResolver((ClassResolver)classResolver);
            FactoryFinderResolver ffr = PluginHelper.getFactoryFinderResolver((CamelContext)answer);
            FactoryFinder ff = ffr.resolveBootstrapFactoryFinder((ClassResolver)classResolver);
            answer.getCamelContextExtension().setBootstrapFactoryFinder(ff);
            ff = ffr.resolveDefaultFactoryFinder((ClassResolver)classResolver);
            answer.getCamelContextExtension().setDefaultFactoryFinder(ff);
            answer.getCamelContextExtension().addContextPlugin(ComponentResolver.class, (Object)new DependencyDownloaderComponentResolver((CamelContext)answer, this.stubPattern, this.silent));
            answer.getCamelContextExtension().addContextPlugin(DataFormatResolver.class, (Object)new DependencyDownloaderDataFormatResolver((CamelContext)answer, this.stubPattern, this.silent));
            answer.getCamelContextExtension().addContextPlugin(LanguageResolver.class, (Object)new DependencyDownloaderLanguageResolver((CamelContext)answer, this.stubPattern, this.silent));
            answer.getCamelContextExtension().addContextPlugin(TransformerResolver.class, (Object)new DependencyDownloaderTransformerResolver((CamelContext)answer, this.stubPattern, this.silent));
            answer.getCamelContextExtension().addContextPlugin(UriFactoryResolver.class, (Object)new DependencyDownloaderUriFactoryResolver((CamelContext)answer));
            answer.getCamelContextExtension().addContextPlugin(ResourceLoader.class, (Object)new DependencyDownloaderResourceLoader((CamelContext)answer, sourceDir));
            answer.setInjector((Injector)new KameletMainInjector(answer.getInjector(), this.stubPattern, this.silent));
            Object kameletsVersion = this.getInitialProperties().get("camel.jbang.kameletsVersion");
            if (kameletsVersion != null) {
                answer.addService((Object)new DependencyDownloaderKamelet((CamelContext)answer, kameletsVersion.toString()));
            } else {
                answer.addService((Object)new DependencyDownloaderKamelet((CamelContext)answer));
            }
            answer.getCamelContextExtension().getRegistry().bind(DownloadModelineParser.class.getSimpleName(), (Object)new DownloadModelineParser((CamelContext)answer));
            if (sourceDir != null) {
                if (console || health) {
                    this.configure().httpServer().withEnabled(true);
                    this.configure().httpServer().withUploadEnabled(true);
                    this.configure().httpServer().withUploadSourceDir(sourceDir);
                }
                RouteOnDemandReloadStrategy reloader = new RouteOnDemandReloadStrategy(sourceDir, true);
                reloader.setPattern("*");
                answer.addService((Object)reloader);
                Object loc = this.initialProperties.getProperty("camel.component.kamelet.location");
                String target = "file:" + sourceDir + ",";
                if (!((String)loc).contains(target)) {
                    loc = target + (String)loc;
                    this.addInitialProperty("camel.component.kamelet.location", (String)loc);
                }
            } else {
                answer.addService((Object)new DefaultContextReloadStrategy());
            }
            String reloadDir = this.getInitialProperties().getProperty("camel.main.routesIncludePattern");
            if (reloadDir != null && reloadDir.startsWith("file:.camel-jbang/generated-clipboard")) {
                String name = reloadDir.substring(5);
                File file = new File(name);
                ClipboardReloadStrategy reloader = new ClipboardReloadStrategy(file);
                answer.addService((Object)reloader);
                PeriodTaskScheduler scheduler = PluginHelper.getPeriodTaskScheduler((CamelContext)answer);
                scheduler.schedulePeriodTask((Runnable)reloader, 2000L);
            }
            String openapi = this.getInitialProperties().getProperty("camel.jbang.open-api");
            String reload = this.getInitialProperties().getProperty("camel.main.routesReloadDirectory");
            if (openapi != null && (reload != null || sourceDir != null)) {
                File file = Paths.get(openapi, new String[0]).toFile();
                OpenApiGeneratorReloadStrategy rs = new OpenApiGeneratorReloadStrategy(file);
                answer.addService((Object)rs);
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
        }
        return answer;
    }

    protected void configurePropertiesService(CamelContext camelContext) throws Exception {
        super.configurePropertiesService(camelContext);
        PropertiesComponent pc = (PropertiesComponent)camelContext.getPropertiesComponent();
        pc.setPropertiesFunctionResolver((PropertiesFunctionResolver)new DependencyDownloaderPropertiesFunctionResolver(camelContext));
    }

    protected void autoconfigure(CamelContext camelContext) throws Exception {
        ClassLoader cl = this.createApplicationContextClassLoader(camelContext);
        camelContext.setApplicationContextClassLoader(cl);
        super.autoconfigure(camelContext);
    }

    protected LifecycleStrategy createLifecycleStrategy(CamelContext camelContext) {
        return new KameletAutowiredLifecycleStrategy(camelContext, this.stubPattern, this.silent);
    }

    protected ClassLoader createApplicationContextClassLoader(CamelContext camelContext) {
        if (this.classLoader == null) {
            ArrayList<String> jars = new ArrayList<String>();
            ArrayList<String> classes = new ArrayList<String>();
            ClassLoader parentCL = KameletMain.class.getClassLoader();
            String cpFiles = this.getInitialProperties().getProperty("camel.jbang.classpathFiles");
            if (cpFiles != null) {
                String[] arr = cpFiles.split(",");
                ArrayList<String> files = new ArrayList<String>();
                for (String s : arr) {
                    if (s.endsWith(".jar")) {
                        jars.add(s);
                        continue;
                    }
                    if (s.endsWith(".class")) {
                        classes.add(s);
                        continue;
                    }
                    files.add(s);
                }
                if (!classes.isEmpty()) {
                    parentCL = new ExtraClassesClassLoader(parentCL, classes);
                    LOG.info("Additional classes added to classpath: {}", (Object)String.join((CharSequence)", ", classes));
                }
                if (!files.isEmpty()) {
                    parentCL = new ExtraFilesClassLoader(parentCL, files);
                    LOG.info("Additional files added to classpath: {}", (Object)String.join((CharSequence)", ", files));
                }
            }
            parentCL = new CamelCustomClassLoader(parentCL, camelContext);
            DependencyDownloaderClassLoader cl = new DependencyDownloaderClassLoader(parentCL);
            if (!jars.isEmpty()) {
                for (String jar : jars) {
                    File f = new File(jar).getAbsoluteFile();
                    if (!f.isFile() || !f.exists()) continue;
                    cl.addFile(f);
                }
                LOG.info("Additional jars added to classpath: {}", (Object)String.join((CharSequence)", ", jars));
            }
            this.classLoader = cl;
        }
        return this.classLoader;
    }

    protected void configureRoutesLoader(CamelContext camelContext) {
        Object kameletsVersion;
        ExtendedCamelContext ecc = camelContext.getCamelContextExtension();
        String dir = this.getInitialProperties().getProperty("camel.jbang.compileWorkDir");
        if (dir != null) {
            CompileStrategy cs = (CompileStrategy)camelContext.getCamelContextExtension().getContextPlugin(CompileStrategy.class);
            if (cs == null) {
                cs = new DefaultCompileStrategy();
                ecc.addContextPlugin(CompileStrategy.class, (Object)cs);
            }
            cs.setWorkDir(dir);
        }
        DependencyDownloaderRoutesLoader routesLoader = (kameletsVersion = this.getInitialProperties().get("camel.jbang.kameletsVersion")) != null ? new DependencyDownloaderRoutesLoader(camelContext, kameletsVersion.toString()) : new DependencyDownloaderRoutesLoader(camelContext);
        routesLoader.setIgnoreLoadingError(this.mainConfigurationProperties.isRoutesCollectorIgnoreLoadingError());
        ecc.addContextPlugin(RoutesLoader.class, (Object)routesLoader);
    }

    protected void configureInitialProperties(String location) {
        this.addInitialProperty("camel.component.kamelet.location", location);
        this.addInitialProperty("camel.component.rest-api.consumerComponentName", "platform-http");
        this.addInitialProperty("camel.component.rest.consumerComponentName", "platform-http");
        this.addInitialProperty("camel.component.rest.producerComponentName", "vertx-http");
    }

    protected String startupInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("Using Java ").append(System.getProperty("java.version"));
        String pid = KameletMain.getPid();
        if (pid != null) {
            sb.append(" with PID ").append(pid);
        }
        sb.append(". Started by ").append(System.getProperty("user.name"));
        sb.append(" in ").append(System.getProperty("user.dir"));
        return sb.toString();
    }

    protected void preProcessCamelRegistry(CamelContext camelContext, MainConfigurationProperties config) {
        TreeMap<String, Document> springXmls = new TreeMap<String, Document>();
        TreeMap<String, Document> blueprintXmls = new TreeMap<String, Document>();
        Map xmlDocs = this.registry.findByTypeWithName(Document.class);
        if (xmlDocs != null) {
            xmlDocs.forEach((id, doc) -> {
                if (id.startsWith("camel-xml-io-dsl-spring-xml:")) {
                    springXmls.put((String)id, (Document)doc);
                } else if (id.startsWith("camel-xml-io-dsl-blueprint-xml:")) {
                    blueprintXmls.put((String)id, (Document)doc);
                }
            });
        }
        if (!springXmls.isEmpty()) {
            this.springXmlBeansHandler.processSpringBeans(camelContext, config, springXmls);
        }
        if (!blueprintXmls.isEmpty()) {
            this.blueprintXmlBeansHandler.processBlueprintBeans(camelContext, config, blueprintXmls);
        }
    }

    protected void postProcessCamelRegistry(CamelContext camelContext, MainConfigurationProperties config) {
        this.springXmlBeansHandler.createAndRegisterBeans(camelContext);
        this.blueprintXmlBeansHandler.createAndRegisterBeans(camelContext);
    }

    private static String getPid() {
        return String.valueOf(ProcessHandle.current().pid());
    }
}

