/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.main.MainAutowiredLifecycleStrategy;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Language;
import org.apache.camel.support.PatternHelper;

public class KameletAutowiredLifecycleStrategy
extends MainAutowiredLifecycleStrategy {
    private final String stubPattern;
    private final boolean silent;

    public KameletAutowiredLifecycleStrategy(CamelContext camelContext, String stubPattern, boolean silent) {
        super(camelContext);
        this.stubPattern = stubPattern;
        this.silent = silent;
    }

    protected boolean isEnabled(String name, Component component) {
        boolean enabled = this.isEnabled(name);
        if (enabled) {
            return super.isEnabled(name, component);
        }
        return false;
    }

    protected boolean isEnabled(String name, Language language) {
        boolean enabled = this.isEnabled(name);
        if (enabled) {
            return super.isEnabled(name, language);
        }
        return false;
    }

    protected boolean isEnabled(String name, DataFormat dataFormat) {
        boolean enabled = this.isEnabled(name);
        if (enabled) {
            return super.isEnabled(name, dataFormat);
        }
        return false;
    }

    protected boolean isEnabled(String name) {
        if (this.silent) {
            return false;
        }
        if (this.stubPattern == null) {
            return true;
        }
        if (this.stubPattern.equals("*")) {
            return false;
        }
        for (String n : this.stubPattern.split(",")) {
            if (!PatternHelper.matchPattern((String)n, (String)this.stubPattern)) continue;
            return false;
        }
        return true;
    }
}

