/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.CamelConfiguration;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Configuration;
import org.apache.camel.main.download.ArtifactDownloadListener;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.support.PluginHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePackageScanDownloadListener
implements ArtifactDownloadListener,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(BasePackageScanDownloadListener.class);
    private CamelContext camelContext;
    private final Set<String> scanned = new HashSet<String>();

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void onDownloadedFile(File file) {
        String basePackage = this.camelContext.getCamelContextExtension().getBasePackageScan();
        if (basePackage != null) {
            try {
                this.basePackageScanConfiguration(basePackage, file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void basePackageScanConfiguration(String basePackage, File file) throws Exception {
        ArrayList<CamelConfiguration> configs = new ArrayList<CamelConfiguration>();
        PackageScanClassResolver pscr = PluginHelper.getPackageScanClassResolver((CamelContext)this.camelContext);
        Set found1 = pscr.findImplementations(CamelConfiguration.class, new String[]{basePackage});
        Set found2 = pscr.findAnnotated(Configuration.class, new String[]{basePackage});
        LinkedHashSet found = new LinkedHashSet();
        found.addAll(found1);
        found.addAll(found2);
        for (Class clazz : found) {
            String string = clazz.getName();
            if (this.scanned.contains(string)) continue;
            this.scanned.add(string);
            Object config = this.camelContext.getInjector().newInstance(clazz);
            if (!(config instanceof CamelConfiguration)) continue;
            LOG.debug("Discovered CamelConfiguration class: {}", (Object)clazz);
            CamelConfiguration cc = (CamelConfiguration)config;
            configs.add(cc);
        }
        CamelBeanPostProcessor postProcessor = PluginHelper.getBeanPostProcessor((CamelContext)this.camelContext);
        for (Object e : configs) {
            postProcessor.postProcessBeforeInitialization(e, e.getClass().getName());
            postProcessor.postProcessAfterInitialization(e, e.getClass().getName());
        }
        for (CamelConfiguration camelConfiguration : configs) {
            camelConfiguration.configure(this.camelContext);
        }
    }
}

