/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.support.classic;

import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.SeekPolicy;
import org.apache.camel.component.kafka.consumer.support.classic.NoOpPartitionAssignmentAdapter;
import org.apache.camel.component.kafka.consumer.support.classic.OffsetPartitionAssignmentAdapter;
import org.apache.camel.component.kafka.consumer.support.classic.PartitionAssignmentAdapter;
import org.apache.camel.component.kafka.consumer.support.classic.SeekPolicyPartitionAssignmentAdapter;
import org.apache.camel.spi.StateRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AssignmentAdapterHelper {
    private static final NoOpPartitionAssignmentAdapter NO_OP_ASSIGNMENT_ADAPTER = new NoOpPartitionAssignmentAdapter();
    private static final Logger LOG = LoggerFactory.getLogger(AssignmentAdapterHelper.class);

    private AssignmentAdapterHelper() {
    }

    public static PartitionAssignmentAdapter resolveBuiltinResumeAdapters(KafkaConfiguration configuration) {
        LOG.debug("No resume strategy was provided ... checking for built-ins ...");
        StateRepository<String, String> offsetRepository = configuration.getOffsetRepository();
        SeekPolicy seekTo = configuration.getSeekTo();
        if (offsetRepository != null) {
            LOG.info("Using resume from offset strategy");
            return new OffsetPartitionAssignmentAdapter(offsetRepository);
        }
        if (seekTo != null) {
            LOG.info("Using resume from seek policy strategy with seeking from {}", (Object)seekTo);
            return new SeekPolicyPartitionAssignmentAdapter(seekTo);
        }
        LOG.info("Using NO-OP resume strategy");
        return NO_OP_ASSIGNMENT_ADAPTER;
    }
}

