/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.producer.support;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.LongAdder;
import org.apache.camel.AsyncCallback;
import org.apache.camel.component.kafka.producer.support.ProducerUtil;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KafkaProducerCallBack
implements Callback {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaProducerCallBack.class);
    private final Object body;
    private final AsyncCallback callback;
    private final LongAdder count = new LongAdder();
    private final ExecutorService workerPool;
    private final boolean record;
    private final List<RecordMetadata> recordMetadataList = new ArrayList<RecordMetadata>();

    public KafkaProducerCallBack(Object body, AsyncCallback callback, ExecutorService workerPool, boolean record) {
        this.body = body;
        this.callback = callback;
        assert (workerPool != null);
        this.workerPool = workerPool;
        this.record = record;
        this.count.increment();
        if (record) {
            ProducerUtil.setRecordMetadata(body, this.recordMetadataList);
        }
    }

    public void increment() {
        this.count.increment();
    }

    public boolean allSent() {
        this.count.decrement();
        if (this.count.intValue() == 0) {
            LOG.trace("All messages sent, continue routing.");
            this.callback.done(true);
            return true;
        }
        return false;
    }

    public void onCompletion(RecordMetadata recordMetadata, Exception e) {
        ProducerUtil.setException(this.body, e);
        if (this.record) {
            this.recordMetadataList.add(recordMetadata);
        }
        this.count.decrement();
        if (this.count.intValue() == 0) {
            this.workerPool.submit(this::doContinueRouting);
        }
    }

    private void doContinueRouting() {
        LOG.trace("All messages sent, continue routing (within thread).");
        this.callback.done(false);
    }
}

