/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.support;

import java.util.Collection;
import org.apache.camel.component.kafka.consumer.support.KafkaConsumerResumeStrategy;
import org.apache.kafka.clients.consumer.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeekPolicyKafkaConsumerResumeStrategy
implements KafkaConsumerResumeStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(SeekPolicyKafkaConsumerResumeStrategy.class);
    private final String seekPolicy;

    public SeekPolicyKafkaConsumerResumeStrategy(String seekPolicy) {
        this.seekPolicy = seekPolicy;
    }

    @Override
    public void resume(Consumer<?, ?> consumer) {
        if (this.seekPolicy.equals("beginning")) {
            LOG.debug("Seeking from the beginning of topic");
            consumer.seekToBeginning((Collection)consumer.assignment());
        } else if (this.seekPolicy.equals("end")) {
            LOG.debug("Seeking from the end off the topic");
            consumer.seekToEnd((Collection)consumer.assignment());
        }
    }
}

