/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.juel;

import de.odysseus.el.ExpressionFactoryImpl;
import de.odysseus.el.util.SimpleContext;
import java.io.IOException;
import javax.el.ArrayELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import javax.el.ValueExpression;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.impl.ExpressionSupport;
import org.apache.camel.language.juel.BeanAndMethodELResolver;
import org.apache.camel.spi.FactoryFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JuelExpression
extends ExpressionSupport {
    public static final String DEFAULT_EXPRESSION_FACTORY_IMPL_CLASS = "de.odysseus.el.ExpressionFactoryImpl";
    private static final Logger LOG = LoggerFactory.getLogger(JuelExpression.class);
    private final String expression;
    private final Class<?> type;
    private ExpressionFactory expressionFactory;

    public JuelExpression(String expression, Class<?> type) {
        this.expression = expression;
        this.type = type;
    }

    public static JuelExpression el(String expression) {
        return new JuelExpression(expression, Object.class);
    }

    public <T> T evaluate(Exchange exchange, Class<T> tClass) {
        ExpressionFactory factory = this.getExpressionFactory(exchange.getContext());
        ELContext context = this.populateContext(this.createContext(), exchange);
        ValueExpression valueExpression = factory.createValueExpression(context, this.expression, this.type);
        Object value = valueExpression.getValue(context);
        return (T)exchange.getContext().getTypeConverter().convertTo(tClass, value);
    }

    public ExpressionFactory getExpressionFactory(CamelContext context) {
        if (this.expressionFactory == null && context != null) {
            try {
                FactoryFinder finder = context.getFactoryFinder("META-INF/services/org/apache/camel/language/");
                Class clazz = finder.findClass("el", "impl.");
                if (clazz != null) {
                    this.expressionFactory = (ExpressionFactory)clazz.newInstance();
                }
            }
            catch (ClassNotFoundException e) {
                LOG.debug("'impl.class' not found", (Throwable)e);
            }
            catch (IOException e) {
                LOG.debug("No impl class for juel ExpressionFactory defined in 'META-INF/services/org/apache/camel/language/el'", (Throwable)e);
            }
            catch (InstantiationException e) {
                LOG.debug("Failed to instantiate juel ExpressionFactory implementation class.", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.debug("Failed to instantiate juel ExpressionFactory implementation class.", (Throwable)e);
            }
        }
        return this.getExpressionFactory();
    }

    public ExpressionFactory getExpressionFactory() {
        if (this.expressionFactory == null) {
            this.expressionFactory = new ExpressionFactoryImpl();
        }
        return this.expressionFactory;
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    protected ELContext populateContext(ELContext context, Exchange exchange) {
        this.setVariable(context, "exchange", exchange, Exchange.class);
        this.setVariable(context, "in", exchange.getIn(), Message.class);
        if (exchange.hasOut()) {
            this.setVariable(context, "out", exchange.getOut(), Message.class);
        }
        return context;
    }

    protected void setVariable(ELContext context, String name, Object value, Class<?> type) {
        ValueExpression valueExpression = this.getExpressionFactory().createValueExpression(value, type);
        SimpleContext simpleContext = (SimpleContext)context;
        simpleContext.setVariable(name, valueExpression);
    }

    protected ELContext createContext() {
        CompositeELResolver resolver = new CompositeELResolver(){
            {
                this.add((ELResolver)new ArrayELResolver(false));
                this.add((ELResolver)new ListELResolver(false));
                this.add((ELResolver)new MapELResolver(false));
                this.add((ELResolver)new ResourceBundleELResolver());
                this.add((ELResolver)new BeanAndMethodELResolver());
            }
        };
        return new SimpleContext((ELResolver)resolver);
    }

    protected String assertionFailureMessage(Exchange exchange) {
        return this.expression;
    }
}

