/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jt400;

import com.ibm.as400.access.MessageQueue;
import com.ibm.as400.access.QueuedMessage;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jt400.Jt400Configuration;
import org.apache.camel.component.jt400.Jt400Endpoint;
import org.apache.camel.component.jt400.Jt400MsgQueueService;
import org.apache.camel.support.ScheduledPollConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jt400MsgQueueConsumer
extends ScheduledPollConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(Jt400MsgQueueConsumer.class);
    private final Jt400MsgQueueService queueService;
    private byte[] messageKey;

    public Jt400MsgQueueConsumer(Jt400Endpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.queueService = new Jt400MsgQueueService(endpoint);
        this.messageKey = null;
    }

    public Jt400Endpoint getEndpoint() {
        return (Jt400Endpoint)super.getEndpoint();
    }

    protected int poll() throws Exception {
        Exchange exchange = this.receive(this.getEndpoint().getReadTimeout());
        if (exchange != null) {
            this.getProcessor().process(exchange);
            return 1;
        }
        return 0;
    }

    protected void doStart() throws Exception {
        this.queueService.start();
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.queueService.stop();
    }

    public Exchange receive(long timeout) {
        MessageQueue queue = this.queueService.getMsgQueue();
        try {
            return this.receive(queue, timeout);
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Unable to read from message queue: " + queue.getPath(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Exchange receive(MessageQueue queue, long timeout) throws Exception {
        this.lock.lock();
        try {
            int seconds = timeout >= 0L ? (int)timeout / 1000 : -1;
            LOG.trace("Reading from message queue: {} with {} seconds timeout", (Object)queue.getPath(), -1 == seconds ? "infinite" : Integer.valueOf(seconds));
            Jt400Configuration.MessageAction messageAction = this.getEndpoint().getMessageAction();
            QueuedMessage entry = queue.receive(this.messageKey, seconds, messageAction.getJt400Value(), null == this.messageKey ? "*ANY" : "*NEXT");
            if (null == entry) {
                Exchange exchange = null;
                return exchange;
            }
            if (Jt400Configuration.MessageAction.SAME == messageAction) {
                this.messageKey = entry.getKey();
            }
            Exchange exchange = this.createExchange(true);
            exchange.getIn().setHeader("SENDER_INFORMATION", (Object)(entry.getFromJobNumber() + "/" + entry.getUser() + "/" + entry.getFromJobName()));
            Jt400MsgQueueConsumer.setHeaderIfValueNotNull(exchange.getIn(), "CamelJt400MessageID", entry.getID());
            Jt400MsgQueueConsumer.setHeaderIfValueNotNull(exchange.getIn(), "CamelJt400MessageFile", entry.getFileName());
            Jt400MsgQueueConsumer.setHeaderIfValueNotNull(exchange.getIn(), "CamelJt400MessageType", entry.getType());
            Jt400MsgQueueConsumer.setHeaderIfValueNotNull(exchange.getIn(), "CamelJt400MessageSeverity", entry.getSeverity());
            Jt400MsgQueueConsumer.setHeaderIfValueNotNull(exchange.getIn(), "CamelJt400Message", entry);
            if (5 == entry.getType()) {
                Jt400MsgQueueConsumer.setHeaderIfValueNotNull(exchange.getIn(), "CamelJt400MessageDefaultReply", entry.getDefaultReply());
                if (this.getEndpoint().isSendingReply()) {
                    Jt400MsgQueueConsumer.setHeaderIfValueNotNull(exchange.getIn(), "CamelJt400MessageReplyToKey", entry.getKey());
                }
            }
            exchange.getIn().setBody((Object)entry.getText());
            Exchange exchange2 = exchange;
            return exchange2;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static void setHeaderIfValueNotNull(Message message, String header, Object value) {
        if (null == value) {
            return;
        }
        message.setHeader(header, value);
    }
}

